package net.saqoosha.garapon {

	/**
	 * 「時間とその時間に対する値」を持った配列から、特定の時間の値を補完してくれるクラス。
	 * ObjectAnimatorで使ってる。
	 */
	public class ValueInterpolator {
		
		[ArrayElementType("Number")]
		private var _time:Array;

		[ArrayElementType("Number")]
		private var _val:Array;

		private var _scale:Number;
		
		/**
		 * コンストラクタ。
		 * @param time	時間の配列。
		 * @param val	値の配列。
		 * @param scale	値に対する倍率。
		 */
		public function ValueInterpolator(time:Array, val:Array, scale:Number = 1) {
			
			var f:Function = function (element:*, index:int, arr:Array):Number {
				return Number(element);
			}
			
			this._time = time.map(f);
			this._val = val.map(f);
			this._scale = scale;
			//trace(this, time, val);
		}
		
		/**
		 * 時間に対する値を補完して返します。
		 * @param	time	時間。
		 * @return		補完された値。
		 */
		public function getValue(time:Number):Number {
			var v:Number;
			
			if (time < this._time[0]) {
				v = this._val[0];
			} else if (this._time[1] < time) {
				v = this._val[1];
			} else {
				v = (time - this._time[0]) / (this._time[1] - this._time[0]) * (this._val[1] - this._val[0]) + this._val[0];
			}

			return v * this._scale;
		}
		
		/**
		 * デバッグでバッグ。
		 * @return String
		 */
		public function toString():String {
			return 'time: [' + this._time.join(',') + '], val: [' + this._val.join(',') + ']';
		}
		
	}
}