package net.saqoosha.garapon
{
	import away3d.core.material.MaterialLibrary;
	import away3d.loaders.Collada;
	
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.events.IEventDispatcher;
	import mx.core.SoundAsset;
	import flash.media.SoundTransform;
	import flash.media.SoundChannel;
		

	/**
 	 * @eventType net.saqoosha.garapon.GaraponEvent
	 */	
	[Event(name='passed', type='net.saqoosha.garapon.GaraponEvent')]

	/**
 	 * @eventType net.saqoosha.garapon.GaraponEvent
	 */	
	[Event(name='stopped', type='net.saqoosha.garapon.GaraponEvent')]


	/**
	 * グルグル。
	 * 抽選器の本体ですよ。
	 */
	public class GaraponWheel extends Collada implements IEventDispatcher {
		
		/**
		* class properties
		*/
		// 回るスピードは制限しておきましょう。
		static public const MAX_ROT_SPEED:Number = 15;
		
		// ガラガラガラガラガラガラ。。。
		[Embed(source="../../../assets/garagara.mp3")]
	    private static var garagaraSound:Class;

		
		/**
		* instance properties
		*/		
		private var _garagara:SoundAsset;
		private var _channel:SoundChannel;

		private var _eventDispatcher:EventDispatcher;
		
		private var _rotSpeed:Number;
		private var _destRot:Number;
		private var _currentRot:Number;
		private var _prevRot:Number;
		private var _checkPoint:Array;

		/**
		 * コンストラクタ。
		 * @param xml			モデル形状のColladaフォーマットXML。
		 * @param materials	マテリアル一式。
		 * @param scale			スケール。
		 */
		public function GaraponWheel(xml:XML, materials:MaterialLibrary=null, scale:Number=1) {
			super(xml, materials, scale);

			this._eventDispatcher = new EventDispatcher();

			this._destRot = 0;
			this._currentRot = 0;
			this._prevRot = 0;
			this._rotSpeed = 0
			this._checkPoint = [45, 130];
			
			// 音つくってボリューム0で鳴らしておく。
			this._garagara = new garagaraSound as SoundAsset;
			this._channel = this._garagara.play(0, 1000000, new SoundTransform(0));
			
			StageRef.getInstance().addEventListener(Event.ENTER_FRAME, this.handleEnterFrame);
		}
		
		/**
		 * グルグルグルグルグル。アニメーション。
		 */
		private function handleEnterFrame(e:Event):void {
			// 回したり。スピード減衰させたり。
			this._destRot += this._rotSpeed;
			this._rotSpeed *= 0.9;
			this._currentRot += (this._destRot - this._currentRot) / 5;
			this.rotationZ = -this._currentRot;

			// スピードに応じてボリュームを変えます
			this._channel.soundTransform = new SoundTransform(Math.min(1.0, this._rotSpeed/5));
			
			// ある角度を通過したかどうかを判定したり。
			var cp:Number, a1:Number, a2:Number, ad:Number, b1:Number, b2:Number;
			a1 = Math.min(this._currentRot, this._prevRot);
			a2 = Math.max(this._currentRot, this._prevRot);
			ad = a2 - a1;
			for (var i:Number = 0; i < this._checkPoint.length; i++) {
				cp = this._checkPoint[i];
				if (cp < 180) {
					b2 = a2 % 360;
					if (b2 < 0)	b2 += 360;
					b1 = b2 - ad;
				} else {
					b1 = a1 % 360;
					if (b1 < 0)	b1 += 360;
					b2 = b1 + ad;
				}
				if (b1 < cp && cp < b2) {
					this.dispatchEvent(new GaraponEvent(GaraponEvent.CHECKPOINT_PASSED, { checkpoint:cp, clockwise:this._prevRot < this._currentRot }));
				}
			}
			
			this._prevRot = this._currentRot;
		}


		/**
		 * getter / setter
		 */		

		public function get currentRot():Number {
			return this._currentRot;
		}
		
		public function get destRot():Number {
			return this._destRot;
		}
		
		public function set destRot(d:Number):void {
			this._destRot = d;
		}
		
		public function get rotSpeed():Number {
			return this._rotSpeed;
		}
		
		public function set rotSpeed(d:Number):void {
			this._rotSpeed += d;
			if (Math.abs(this._rotSpeed) > GaraponWheel.MAX_ROT_SPEED) {
				this._rotSpeed =  GaraponWheel.MAX_ROT_SPEED * (this._rotSpeed / Math.abs(this._rotSpeed));
			}
		}
		
		public function get realRotSpeed():Number {
			return this._currentRot - this._prevRot;
		}
		
		public function get isClockwise():Boolean {
			return this._rotSpeed >= 0;
		}


		/**
		 * 以下、IEventDispatcher のメソッド。コピペ。
		 */		
		public function addEventListener( type: String, listener: Function, useCapture: Boolean = false, priority: int = 0, useWeakReference: Boolean = false ): void  {
			this._eventDispatcher.addEventListener( type, listener, useCapture, priority, useWeakReference );
		}
		public function dispatchEvent(event:Event):Boolean {
			return this._eventDispatcher.dispatchEvent(event);
		}
		public function hasEventListener( type: String ): Boolean {
			return this._eventDispatcher.hasEventListener( type );
		}
		public function removeEventListener( type: String, listener: Function, useCapture: Boolean = false ): void {
			this._eventDispatcher.removeEventListener( type, listener, useCapture );
		}
		public function willTrigger( type: String ): Boolean {
			return this._eventDispatcher.willTrigger( type );
		}

	}
}