package net.saqoosha.garapon {

	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.events.IOErrorEvent;
	import flash.net.URLRequest;
	
	
	/**
	 * 玉情報クラス。
	 */
	public class BallInfo extends EventDispatcher {
		
		private var _name:String;
		private var _loader:Loader;
		private var _bitmap:Bitmap;
		
		/**
		 * コンストラクタ。
		 * @param name	お名前をどうぞ。
		 */
		public function BallInfo(name:String) {
			super(this);
			this._name = name;
		}

		/**
		 * 玉テクスチャを読み込んでください。
		 * @param imgurl	画像ファイルへのURL。
		 */
		public function load(imgurl:String):void {
			this._loader = new Loader();
			this._loader.contentLoaderInfo.addEventListener(Event.COMPLETE, this.handleImageLoaded);
			this._loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, this.handleImageLoadError);
			this._loader.load(new URLRequest(imgurl));
		}		

		/**
		 * 読み込めました。
		 */
		private function handleImageLoaded(e:Event):void {
			this.dispatchEvent(e);
		}
		
		/**
		 * 読み込めませんでした。
		 */
		private function handleImageLoadError(e:IOErrorEvent):void {
			trace(e);
		}
		
		/**
		 * getter
		 */
		public function get name():String {
			return this._name;
		}
		public function get bitmapData():BitmapData {
			return Bitmap(this._loader.content).bitmapData;
		}
		
	}
}