package net.saqoosha.garapon {

	import away3d.cameras.HoverCamera3D;
	import away3d.core.material.BitmapMaterial;
	import away3d.core.material.ColorMaterial;
	import away3d.core.material.MaterialLibrary;
	import away3d.core.math.Matrix3D;
	import away3d.core.math.Number3D;
	import away3d.core.proto.Camera3D;
	import away3d.core.proto.Object3D;
	import away3d.core.proto.ObjectContainer3D;
	import away3d.core.proto.Scene3D;
	import away3d.core.render.AnotherRivalFilter;
	import away3d.core.render.BasicRenderer;
	import away3d.core.render.IRenderer;
	import away3d.core.render.QuadrantRenderer;
	import away3d.loaders.Collada;
	import away3d.test.Panel;
	
	import caurina.transitions.Tweener;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.events.KeyboardEvent;
	import flash.filters.DropShadowFilter;
	import flash.filters.GlowFilter;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	
	import org.wiiflash.Wiimote;
	import org.wiiflash.events.ButtonEvent;
	import org.wiiflash.events.WiimoteEvent;


	public class App extends Sprite {

		// instance property
		private var _ballConfig:BallConfig;
		private var _collada:XML;
		
		private var _container:Sprite;
		private var _scene:Scene3D;
		private var _cameraTarget:Object3D;
		private var _camera:HoverCamera3D;
		private var _renderer:IRenderer;
		private var _animator:ObjectAnimator;
		
		private var _obj:Object3D;
		private var _wheel:GaraponWheel;
		private var _ball:Ball;
		private var _currentBallInfo:BallInfo;
		private var _nameField:TextField;
		private var _slidePanel:SlidePanel;
		
		private var _wiimote:Wiimote;
		private var _recognizer:GestureRecognizer;
		
		private var _demoMode:Boolean;
		private var _keyState:Object;
		private var _keyEnabled:Boolean;

		
		/**
		 * コンストラクタ。エントリポイント。
		 * 玉リスト読み込む。
		 */	
		public function App() {
			// Object3D の scale プロパティは読み出し専用なので Tweener でアニメさせるために Special Property として登録。。
			Tweener.registerSpecialProperty('scale', this.getObject3DScale, this.setObject3DScale);
			
			this._demoMode = false;
			this._keyEnabled = true;
			
			// 玉のリストを読み込みましょう。
			this._ballConfig = new BallConfig();
			this._ballConfig.addEventListener(Event.COMPLETE, this.handleBallImageLoaded);
			this._ballConfig.load();
		}
		
		/**
		 * 玉リスト読み込み完了。
		 * 次は。Wiimoteの初期化。
		 */		
		private function handleBallImageLoaded(e:Event):void {
			this._wiimote = new Wiimote();
			this._wiimote.addEventListener(Event.CONNECT, this.handleWiimoteConnected);
			this._wiimote.addEventListener(IOErrorEvent.IO_ERROR, this.handleWiimoteConnectFailed);
			this._wiimote.connect();
		}
		
		/**
		 * Wiimote接続完了なり。
		 */		
		private function handleWiimoteConnected(e:Event):void {
			trace('Wiimote connected.');
			this._wiimote.addEventListener(ButtonEvent.ONE_PRESS, this.handleOnePress);
			this._wiimote.addEventListener(ButtonEvent.TWO_PRESS, this.handleTwoPress);
			// Wiimote のジェスチャー認識クラス。つくりますよ。
			this._recognizer = new GestureRecognizer(this._wiimote);
			this._recognizer.addEventListener(GestureEvent.RECOGNIZED, this.handleGestureRecognized);
			this.initScene();
		}
		
		/**
		 * Wiimote接続エラー。Wiimote使ってないでしょー。
		 */		
		private function handleWiimoteConnectFailed(e:IOErrorEvent):void {
			trace('Failed to connect Wiimote');
			this._wiimote = null;
			this.initScene();
		}
		
		/**
		 * demo モード切り替え。
		 */		
		private function handleOnePress(e:ButtonEvent):void {
			this._demoMode = !this._demoMode;
		}
		
		/**
		 * Wiimote 2 ボタンでレンダラーを切り替える。作り直してるけど。
		 */		
		private function handleTwoPress(e:ButtonEvent):void {
			if (this._renderer is BasicRenderer) {
				this._renderer = new QuadrantRenderer(new AnotherRivalFilter());
			} else {
				this._renderer = new BasicRenderer();
			}
		}
		
		/**
		 * よーやくシーンを作り始めます。
		 */		
		private function initScene():void {
			// このへんはデバッグ用カメラ動かし用。
			this._keyState = new Object();
			this.stage.addEventListener(KeyboardEvent.KEY_DOWN, this.handleKeyDown);
			this.stage.addEventListener(KeyboardEvent.KEY_UP, this.handleKeyUp);
			
			// 背景は普通に。
			var bg:Bitmap = Asset.background;
			bg.smoothing = true;
			bg.x = -bg.width / 2;
			bg.y = -bg.height / 2;
			this.addChild(bg);
			
			// シーン作って addChild。このへんはちょっと Papervision3D とちがう。
			this._scene = new Scene3D();
			this.addChild(this._scene.container);
			
			// マテリアルリスト作る。マテリアル名は Blender でつけたやつ。
			var matlist:MaterialLibrary = new MaterialLibrary();
			matlist.add(new BitmapMaterial(Asset.octagonMain), 'octagon-side');
			matlist.add(new BitmapMaterial(Asset.octagonSide), 'octagon-belt');
			matlist.add(new BitmapMaterial(Asset.octagonHole), 'octagon-hole');
			matlist.add(new BitmapMaterial(Asset.hashira), 'hashira');
			matlist.add(new BitmapMaterial(Asset.hashiraSide), 'hashira-side');
			matlist.add(new BitmapMaterial(Asset.metal), 'metal');
			matlist.add(new BitmapMaterial(Asset.uke), 'uke');
			matlist.add(new BitmapMaterial(Asset.base), 'base1');
			matlist.add(new BitmapMaterial(Asset.ground), 'ground');
			matlist.add(new ColorMaterial(0x000000, 1), 'octagon-hole-end');
			
			// オブジェクト作りましょう。
			this._collada = new XML(new Asset.GaraponBaseClass());
			this._obj = this._scene.addChild(new Collada(this._collada, matlist, 2));
			this._wheel = new GaraponWheel(new XML(new Asset.GaraponWheelClass()), matlist, 2);
			this._wheel.addEventListener(GaraponEvent.CHECKPOINT_PASSED, this.handleCheckpointPassed);
			this._scene.addChild(this._wheel);

			// これはカメラのターゲット。カメラはこっち向く。
			this._cameraTarget = new Object3D();
			this._cameraTarget.x = 546;
			this._cameraTarget.y = -100;
			
			// そしてカメラを作ります。
			this._camera = new HoverCamera3D(this._cameraTarget, 0.7, 1000);
			this._camera.distance = 1580;
			this._camera.panangle = this._camera.targetpanangle = 136;
			this._camera.tiltangle = this._camera.targettiltangle = 6;
			this._camera.mintiltangle = -5;
			this._camera.hover();

			// レンダラーを作りましょう。
			// Away3D はレンンダラーを切り替えられるようになっています。
			// こっちのレンダラーは Z-order の計算をちゃんとやってるのでポリゴンの前後関係がおかしくなったりしないです。
			// までもその分、重いんだけど。。
			this._renderer = new QuadrantRenderer(new AnotherRivalFilter());

			// こっちは Papervsion3D とおんなじかな？ 前後関係が乱れるときがある。
			//this._renderer = new BasicRenderer();
			
			// いつもどおり ENTER_FRAME イベントをリッスン。
			this.addEventListener(Event.ENTER_FRAME, this.handleEnterFrame);
			
			// キーボードの説明もつけておきます。
			var inst:Bitmap = Asset.instruction;
			inst.x = -this.stage.stageWidth / 2;
			inst.y = this.stage.stageHeight  / 2 - inst.height;
			this.addChild(inst);
		}
		
		/**
		 * ジェスチャーを認識しちゃったときに呼ばれるイベントハンドラ。
		 */		
		private function handleGestureRecognized(e:GestureEvent):void {
			switch (e.gesture) {
				case 'cw':  // clockwise 時計回り
					this._wheel.rotSpeed += 2;
					break;
				case 'ccw': // counterclockwise 反時計回り
					this._wheel.rotSpeed -= 2;
					break;
			}
		}
		
		/**
		 * GaraponWheelがある角度を通過したら呼ばれるイベントハンドラ。
		 */		
		private function handleCheckpointPassed(e:GaraponEvent):void {
			if (e.checkpoint == 45 && e.clockwise) {
				
			} else if (e.checkpoint == 130 && e.clockwise) {
				// ジェスチャー認識とめる。
				if (this._recognizer is GestureRecognizer) {
					this._recognizer.enabled = false;
				}
				// キーボードもちょっと使えなくして。
				this._keyEnabled = false;
				// 玉つくる。
				var tex:BitmapData;
				if (this._demoMode) { // demo モードんときは大当たり。
					this._currentBallInfo = new BallInfo('');
					tex = Asset.gold;
				} else { // 通常時。XMLのデータで。
					this._currentBallInfo = this._ballConfig.getRandomBall();
					tex = this._currentBallInfo is BallInfo ? this._currentBallInfo .bitmapData : null;
				}
				this._ball = new Ball(new XML(new Asset.BallClass()), tex, 2);
				this._ball.addEventListener(Event.COMPLETE, this.handleBallStopped);
				// なんとなくそれっぽく玉を吐き出す。初速とか。
				var a:Number = (90 - this._wheel.currentRot) * (Math.PI / 180);
				var ca:Number = Math.cos(a);
				var sa:Number = Math.sin(a);
				var px:Number = ca * 333;  // 玉の出口はだいたいこのへん。
				var py:Number = sa * 333;
				var r:Number = this._wheel.realRotSpeed * 2;
				var sx:Number = ca * r;  // 遠心力とかテキトー。
				var sy:Number = sa * r;
				this._ball.start(px, py, sx, sy);
				this._scene.addChild(this._ball);
			}
		}
		
		/**
		 * 玉コロコロ出てきた。止まった。
		 */		
		private function handleBallStopped(e:Event):void {
			// 次は玉をカメラの真ん前まで動かします。
			var b:Ball = Ball(e.target);
			var org:Matrix3D = b.transform.clone();  // とりあえずいまの場所とかを保存。
			b.transform = this._camera.transform.clone();  // カメラとおなじ位置＆向きにして
			b.moveForward(180); // カメラ前方向に動かして。
			b.moveUp(50);
			b.lookAt(this._cameraTarget); // カメラとおんなじ方向にむける。
			b.rotationX = b.rotationX;  // なんかこうしないと回ってくれないっぽい。
			b.rotationZ = 0;
			b.extra = { scale:1 }; // scale アニメ用に extra に設定。

			var opt:Object = { // Tween プロパティ。
				x:b.x, y:b.y, z:b.z,
				rotationX:b.rotationX, rotationY:b.rotationY, rotationZ:b.rotationZ,
				scale:10, time:2,
				onComplete:this.showBallName
			};

			b.transform = org;  // 元の位置にもどしましょう。

			Tweener.addTween(b, opt); // アニメスタート。
		}
		
		/**
		 * 玉ズームアップ完了。お名前を表示しましょう。
		 */		
		private function showBallName():void {
			this._nameField = new TextField();
			var fmt:TextFormat = new TextFormat('_sans', 32, 0xffffff);
			this._nameField.defaultTextFormat = fmt;
			this._nameField.autoSize = TextFieldAutoSize.CENTER;
			this._nameField.embedFonts = false;
			this._nameField.text = this._currentBallInfo.name ? this._currentBallInfo.name : '大当たり〜〜！';
			this._nameField.x = -this._nameField.textWidth / 2;
			this._nameField.y = 120;
			this._nameField.filters = [new DropShadowFilter(0, 0, 0x000000, 0.8, 4, 4, 8, 1), new GlowFilter(0xffffff, 0.8, 8, 8, 8, 2)];
			this.addChild(this._nameField);
			
			if (this._wiimote is Wiimote) {
				this._wiimote.addEventListener(ButtonEvent.A_PRESS, this.reset);
			}
		}
		
		/**
		 * リセットしましょ。
		 */		
		private function reset(e:Event):void {
			if (this._wiimote) {
				this._wiimote.removeEventListener(ButtonEvent.A_PRESS, this.reset);
				this._recognizer.enabled = true;
			}
			if (this._ball) {
				this._scene.removeChild(this._ball);
				this.removeChild(this._nameField);
			}
			this._keyEnabled = true;
		}

		/**
		 * レンダリングレンダリングー。
		 */		
		private function handleEnterFrame(e:Event):void {
			if (this._keyEnabled) {
				this.debugMove();
			}
			this._camera.hover();
			this._scene.render(this._camera, this._renderer);
		}
		
		
		/**
		 * Tweener の Special Property 用の getter / setter
		 */		
		private function getObject3DScale(p_obj:Object):Number {
			return Object3D(p_obj).extra.scale;
		}
		private function setObject3DScale(p_obj:Object, p_value:Number):void {
			Object3D(p_obj).scale = Object3D(p_obj).extra.scale = p_value;
		}


		/**
		 * このへんはデバグ用カメラ動かし用。
		 */		
		private function handleKeyDown(e:KeyboardEvent):void {
			trace('keydown',e.keyCode);
			this._keyState[e.keyCode] = true;
			
			switch (e.keyCode) {
				case 90:  // Z
					trace(this._camera.distance, this._camera.panangle, this._camera.tiltangle);
					trace(this._cameraTarget);
					break;
				case 32:  // (space)
					if (!this._keyEnabled) {  // このへんの実装は美しくない。。とりあえず動けばヨシ。
						this.reset(null);
					}
					break;
			}
		}
		private function handleKeyUp(e:KeyboardEvent):void {
			trace('keyup',e.keyCode);
			delete this._keyState[e.keyCode];
		}
		private function debugMove():void {
			for (var charCode:String in this._keyState) {
				switch (Number(charCode)) {
					case 37: //left
						this._wheel.rotSpeed -= 1;
						break;
					case 39: //right;
						this._wheel.rotSpeed += 1;
						break;
					case 38: //up
						this._camera.distance += 5;
						break;
					case 40: //down
						this._camera.distance -= 5;
						break;
					
					case 87: // W
						//this._cameraTarget.moveUp(3);
						this._camera.targettiltangle += 3;
						break;
					case 83: // S
						//this._cameraTarget.moveDown(3);
						this._camera.targettiltangle -= 3;
						break;
					case 65: // A
						//this._cameraTarget.moveLeft(3);
						this._camera.targetpanangle += 3;
						break;
					case 68: // D
						//this._cameraTarget.moveRight(3);
						this._camera.targetpanangle -= 3;
						break;
				}
			}
		}

	}
}


	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import mx.core.BitmapAsset;
	import mx.core.SoundAsset;
	
	/**
	 * SWF埋め込みの素材たちはこのクラスにまとめる。Away3Dのサンプルのパクり。
	 */
	class Asset {

		[Embed(source="../../../assets/garapon-base.dae",mimeType="application/octet-stream")]
		public static var GaraponBaseClass:Class;

		[Embed(source="../../../assets/garapon-wheel.dae",mimeType="application/octet-stream")]
		public static var GaraponWheelClass:Class;

		[Embed(source="../../../assets/ball.dae",mimeType="application/octet-stream")]
		public static var BallClass:Class;

		[Embed(source="../../../assets/octagon-main.jpg")]
	    private static var OctagonMainImage:Class;
	    public static function get octagonMain():BitmapData  {
	        return (new OctagonMainImage as BitmapAsset).bitmapData;
	    }

		[Embed(source="../../../assets/octagon-side.jpg")]
	    private static var OctagonSideImage:Class;
	    public static function get octagonSide():BitmapData  {
	        return (new OctagonSideImage as BitmapAsset).bitmapData;
	    }

		[Embed(source="../../../assets/hole.jpg")]
	    private static var OctagonHoleImage:Class;
	    public static function get octagonHole():BitmapData  {
	        return (new OctagonHoleImage as BitmapAsset).bitmapData;
	    }

		[Embed(source="../../../assets/metal.jpg")]
	    private static var MetalImage:Class;
	    public static function get metal():BitmapData  {
	        return (new MetalImage as BitmapAsset).bitmapData;
	    }

		[Embed(source="../../../assets/hashira.jpg")]
	    private static var HashiraImage:Class;
	    public static function get hashira():BitmapData  {
	        return (new HashiraImage as BitmapAsset).bitmapData;
	    }

		[Embed(source="../../../assets/hashira-side.jpg")]
	    private static var HashiraSideImage:Class;
	    public static function get hashiraSide():BitmapData  {
	        return (new HashiraSideImage as BitmapAsset).bitmapData;
	    }

		[Embed(source="../../../assets/uke.jpg")]
	    private static var ukeImage:Class;
	    public static function get uke():BitmapData  {
	        return (new ukeImage as BitmapAsset).bitmapData;
	    }

		[Embed(source="../../../assets/base.jpg")]
	    private static var baseImage:Class;
	    public static function get base():BitmapData  {
	        return (new baseImage as BitmapAsset).bitmapData;
	    }

		[Embed(source="../../../assets/gold.png")]
	    private static var goldImage:Class;
	    public static function get gold():BitmapData  {
	        return (new goldImage as BitmapAsset).bitmapData;
	    }

		[Embed(source="../../../assets/ground.png")]
	    private static var groundImage:Class;
	    public static function get ground():BitmapData  {
	        return (new groundImage as BitmapAsset).bitmapData;
	    }

		[Embed(source="../../../assets/bg.png")]
	    private static var backgroundImage:Class;
	    public static function get background():Bitmap  {
	        return (new backgroundImage as Bitmap);
	    }

		[Embed(source="../../../assets/instruction.png")]
	    private static var instructionImage:Class;
	    public static function get instruction():Bitmap  {
	        return (new instructionImage as Bitmap);
	    }


	}
