package net.saqoosha.foyh {
	
	import flash.display.BitmapData;
	import flash.display.GradientType;
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.SpreadMethod;
	import flash.geom.Matrix;
	
	import net.saqoosha.util.ColorUtil;
	
	import org.papervision3d.core.geom.Particles;
	import org.papervision3d.core.geom.renderables.Vertex3D;
	import org.papervision3d.materials.special.ParticleMaterial;

	public class Firework extends Particles {
		
		private static const GLOBAL_DRAG:Number = 0.96;
		private static const GRAVITY:Number = 0.01;
		
		private var _mat:ParticleMaterial;
		private var _color:BitmapData;
		private var _isFinisded:Boolean;
	
		public function Firework() {
			super(null);
			this._makeColor();
			this._mat = new ParticleMaterial(this._color.getPixel(0, 0), 0.5 + Math.random(), ParticleMaterial.SHAPE_CIRCLE);
			this._mat.fillAlpha = 0.5;
			this.addParticle(new FireParticle(this._mat, 1.5));
		}
		
		private function _makeColor():void {
			var sh:Shape = new Shape();
			var g:Graphics = sh.graphics;
			var mtx:Matrix = new Matrix();
			mtx.createGradientBox(256, 1, 0, 0, 0);
			g.beginGradientFill(GradientType.LINEAR, [
				ColorUtil.HSV2int(Math.random() * 360, 0.2, 1.0),
				ColorUtil.HSV2int(Math.random() * 360, 0.5, 1.0),
				ColorUtil.HSV2int(Math.random() * 360, 1.0, 1.0)
			], [1.0, 1.0, 1.0], [50, 100 + Math.random() * 50, 200], mtx, SpreadMethod.PAD);
			g.drawRect(0, 0, 256, 1);
			g.endFill();
			this._color = new BitmapData(256, 1, false, 0x0);
			this._color.draw(sh);
		}
		
		public function explode():void {
			this.removeAllParticles();
			var sp:Number = 1 + Math.random() * 0.8;
			for each (var v:Vertex3D in new GeosphereVertices(1.0, Math.floor(Math.random() * 3) + 1).vertices) {
				var p:FireParticle = new FireParticle(this._mat, 2);
				p.vx = v.x * sp;
				p.vy = v.y * sp;
				p.vz = v.z * sp;
				this.addParticle(p);
			}
			this._mat.fillAlpha = 1.0;
			this._isFinisded = false;
		}
		
		public function step():Boolean {
			var p:FireParticle;
			for each (p in this.particles) {
				p.x += p.vx;
				p.y += p.vy;
				p.z += p.vz;
				p.vx *= GLOBAL_DRAG;
				p.vy *= GLOBAL_DRAG;
				p.vz *= GLOBAL_DRAG;
				p.vz -= GRAVITY;
			}
			this._mat.fillAlpha *= 0.97;
			this._mat.fillColor = this._color.getPixel((1 - this._mat.fillAlpha) * this._color.width, 0);
			if (this._mat.fillAlpha <= 0.03) {
				this._mat.fillAlpha = 0;
				this._isFinisded = true;
			}
			return this._isFinisded;
		}
		
		public function get isFinished():Boolean { 
			return this._isFinisded;
		}
		
		public function destroy():void {
			this.removeAllParticles();
			this._mat = undefined;
			this._color.dispose();
			this._color = undefined;
		}
		
		public function get fillAlpha():Number {
			return this._mat.fillAlpha;
		}
		
		public function set fillAlpha(value:Number):void {
			this._mat.fillAlpha = value;
		}
		
	}
	
}


import org.papervision3d.core.geom.renderables.Vertex3D;
import org.papervision3d.core.math.Number3D;

class GeosphereVertices {
	
	private static const MIN_SEGMENTS:uint = 1;
	private static const DEFAULT_SEGMENTS:uint = 3;
	private static const DEFAULT_RADIUS:Number = 100;
	
	private var _segments:uint;
	private var _vertices:Array;
		
	public function GeosphereVertices(radius:Number = 1.0, segments:uint = 1) {
		this._segments = Math.max(MIN_SEGMENTS, segments || DEFAULT_SEGMENTS); // Defaults to 8
		if (radius == 0)	radius = DEFAULT_RADIUS; // Defaults to 100
		this.buildGeosphere(radius);
	}
	
	private function buildGeosphere(radius:Number):void {
		var nsections:uint = 20;
		var subrad:Number, subz:Number, theta:Number, sn:Number, cs:Number;
		var i:int, f:int;
		
		var aVertice:Array = this._vertices = [];

		// get first 12 Vertices //
		aVertice.push(new Vertex3D(0, 0, radius));
		subz = Math.sqrt(0.2) * radius;
		subrad = 2 * subz;
		for (i = 0; i < 5; i++) {
			theta = 2 * Math.PI * i / 5;
			sn = Math.sin (theta);
			cs = Math.cos (theta);
			aVertice.push(new Vertex3D(subrad * cs, subrad * sn, subz));
		}
		for (i = 0; i < 5; i++) {
			theta = Math.PI * (2 * i + 1) / 5;
			sn = Math.sin (theta);
			cs = Math.cos (theta);
			aVertice.push(new Vertex3D(subrad * cs, subrad * sn, -subz));
		}
		aVertice.push(new Vertex3D(0, 0, -radius));
		
		// tessellate triangles
		for (i = 0; i < 5 ; i++) interpolate(0, i + 1, this._segments);
		for (i = 0; i < 5 ; i++) interpolate(i + 1, (i + 1) % 5 + 1, this._segments);
		for (i = 0; i < 5 ; i++) interpolate(i + 1, i + 6, this._segments);
		for (i = 0; i < 5 ; i++) interpolate(i + 1, (i + 4) % 5 + 6, this._segments);
		for (i = 0; i < 5 ; i++) interpolate(i + 6, (i + 1) % 5 + 6, this._segments);
		for (i = 0; i < 5 ; i++) interpolate(11, i + 6, this._segments);
		for (f = 0; f < 5 ; f++) {
			for (i = 1; i <= this._segments - 2; i++) {
				interpolate(12 + f * (this._segments - 1) + i, 12 + ((f + 1) % 5) * (this._segments - 1) + i, i + 1);
			}
		}
		for (f = 0; f < 5 ; f++) {
			for (i = 1; i <= this._segments - 2 ; i++) {
				interpolate(12 + (f + 15) * (this._segments - 1) + i, 12 + (f + 10) * (this._segments - 1) + i, i + 1);
			}
		}
		for (f = 0; f < 5 ; f++) {
			for (i = 1; i <= this._segments - 2 ; i++) {
				interpolate(12 + (((f + 1) % 5) + 15) * (this._segments - 1) + this._segments - 2 - i, 12 + (f + 10) * (this._segments - 1) + this._segments - 2 - i, i + 1);
			}
		}
		for (f = 0; f < 5 ; f++) {
			for (i = 1; i <= this._segments - 2 ; i++) {
				interpolate(12 + (((f + 1) % 5) + 25) * (this._segments - 1) + i, 12 + (f + 25) * (this._segments - 1) + i, i + 1);
			}
		}
	}
	
	private function interpolate(v1:uint, v2:uint, num:uint):void {
		if (this._segments < 2) return;
		var aVertice:Array = this._vertices;
		var a:Vertex3D = aVertice[v1];
		var b:Vertex3D = aVertice[v2];
		var rad:Number = Number3D.dot(a.toNumber3D(), a.toNumber3D());
		var cs:Number = Number3D.dot(a.toNumber3D(), b.toNumber3D()) / rad;
		cs = (cs < -1) ? -1 : (cs > 1) ? 1 : cs;
		var theta:Number = Math.acos(cs);
		var sn:Number = Math.sin(theta);
		for (var e:int = 1; e <= num - 1; e++) {
			var np:Vertex3D = new Vertex3D();
			var theta1:Number = (theta * e) / num;
			var theta2:Number = (theta * (num - e)) / num;
			var st1:Number = Math.sin(theta1);
			var st2:Number = Math.sin(theta2);
			np.x = (a.x * st2 + b.x * st1) / sn;
			np.y = (a.y * st2 + b.y * st1) / sn;
			np.z = (a.z * st2 + b.z * st1) / sn;
			aVertice.push(np);
		}
	}
	
	public function get vertices():Array {
//		trace('Num vertices:', this._vertices.length);
		return this._vertices;
	}
	
}
