package net.saqoosha.sonicodeclock {
	import net.saqoosha.gui.ParameterSlider;
	import net.saqoosha.util.LayoutUtil;
	
	import uranodai.oscemote.OSCemote;
	import uranodai.oscemote.event.OSCemoteSegmentEvent;
	import uranodai.oscemote.event.OSCemoteSliderEvent;
	import uranodai.oscemote.event.OSCemoteSwitchEvent;
	
	import de.popforge.parameter.Parameter;
	
	import com.trick7.utils.TeraClock;

	import org.libspark.thread.Thread;
	import org.libspark.thread.threads.display.LoaderThread;
	import org.sazameki.audio.processor.oscillator.IOsc;
	import org.sazameki.audio.processor.oscillator.NoiseOsc;
	import org.sazameki.audio.processor.oscillator.SawOsc;
	import org.sazameki.audio.processor.oscillator.SineOsc;
	import org.sazameki.audio.processor.oscillator.SquareOsc;
	import org.sazameki.audio.processor.oscillator.TriOsc;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.SampleDataEvent;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.media.Sound;
	import flash.net.SharedObject;
	import flash.net.URLRequest;
	import flash.system.ApplicationDomain;
	import flash.system.LoaderContext;	

	/**
	 * @author Saqoosha
	 */
	public class MainThread extends Thread {

		private static const ZERO_POINT:Point = new Point(0, 0);
		private static const PI2:Number = Math.PI * 2;

		private var _base:Sprite;
		private var _teraClock:TeraClock;
		private var _loader:LoaderThread;
		private var _digits:ClockDigits;
		private var _waveTemplate:Bitmap;
		private var _waveImage:Bitmap;
		private var _sound:Sound;
		private var _data:Vector.<RangeData>;
		private var _freq:Number = 440;
		private var _phase:Number = 0;
		private var _oscilators:Array;

		private var _contols:Sprite;
		private var _so:SharedObject;
		private var _rotationSlider:ParameterSlider;
		private var _spacingSlider:ParameterSlider;
		private var _scaleXSlider:ParameterSlider;
		private var _scaleYSlider:ParameterSlider;
		private var _lowerFreqSlider:ParameterSlider;
		private var _upperFreqSlider:ParameterSlider;
		private var _waveKindSlider:ParameterSlider;
		
		private var _oscemote:OSCemote;

		public function MainThread(base:Sprite) {
			this._base = base;
		}

		protected override function run():void {
			this._loader = new LoaderThread(new URLRequest('assets.swf'), new LoaderContext(false, ApplicationDomain.currentDomain));
			this._loader.start();
			this._loader.join();
			next(this._onTemplateLoaded);
		}

		private function _onTemplateLoaded():void {
			this._digits = new ClockDigits();
			this._teraClock = new TeraClock();
			this._oscilators = [new SineOsc(), new SquareOsc(), new SawOsc(), new TriOsc(), new NoiseOsc()];
			
			var bmp:BitmapData = new BitmapData(Constants.CANVAS_WIDTH, Constants.CANVAS_HEIGHT, false, 0x0);
			this._waveTemplate = this._base.addChild(new Bitmap(bmp)) as Bitmap;
			this._waveTemplate.visible = false;
			this._waveTemplate.alpha = 0.5;
			
			bmp = new BitmapData(Constants.CANVAS_WIDTH, Constants.CANVAS_HEIGHT, true, 0x0);
			this._waveImage = this._base.addChild(new Bitmap(bmp)) as Bitmap;
			this._waveImage.visible = false;
			
			this._data = new Vector.<RangeData>();
			for (var i:int;i < this._base.stage.stageWidth; i++) {
				this._data.push(new RangeData());
			}
			
			this._contols = this._base.addChild(new Sprite()) as Sprite;
			this._contols.visible = false;
			this._so = SharedObject.getLocal('parameter');
			this._rotationSlider = this._contols.addChild(ParameterSlider.createNumber(-180, 180, 0, 300, 'Rotation', this._so)) as ParameterSlider;
			this._rotationSlider.parameter.addChangedCallbacks(this._onChangeRotation);
			this._spacingSlider = this._contols.addChild(ParameterSlider.createNumber(0, 100, 20, 300, 'Spacing', this._so)) as ParameterSlider;
			this._spacingSlider.parameter.addChangedCallbacks(this._onChangeSpacing);
			this._scaleXSlider = this._contols.addChild(ParameterSlider.createNumber(-2, 2, 1, 300, 'ScaleX', this._so)) as ParameterSlider;
			this._scaleXSlider.parameter.addChangedCallbacks(this._onChangeScaleX);
			this._scaleYSlider = this._contols.addChild(ParameterSlider.createNumber(-2, 2, 1, 300, 'ScaleY', this._so)) as ParameterSlider;
			this._scaleYSlider.parameter.addChangedCallbacks(this._onChangeScaleY);
			this._waveKindSlider = this._contols.addChild(ParameterSlider.createInt(0, 4, 0, 300, 'Oscilator', this._so)) as ParameterSlider;
			this._lowerFreqSlider = this._contols.addChild(ParameterSlider.createNumber(10, 2000, 200, 300, 'lowerFreq', this._so)) as ParameterSlider;
			this._upperFreqSlider = this._contols.addChild(ParameterSlider.createNumber(10, 2000, 1200, 300, 'upperFreq', this._so)) as ParameterSlider;
			LayoutUtil.alignVertical(10, Constants.CANVAS_HEIGHT + 10, 2, [this._rotationSlider, this._spacingSlider, this._scaleXSlider, this._scaleYSlider]);
			LayoutUtil.alignVertical(10 + 300 + 20, Constants.CANVAS_HEIGHT + 10, 2, [this._waveKindSlider, this._lowerFreqSlider, this._upperFreqSlider]);
			
			this._digits.rotation = this._rotationSlider.value;
			this._digits.spacingX = this._spacingSlider.value;
			this._digits.scaleX = this._scaleXSlider.value;
			this._digits.scaleY = this._scaleYSlider.value;
			this._generateRangeData();
			
			this._sound = new Sound();
			this._sound.addEventListener('sampleData', this._onSampleData);
			this._sound.play();
			
			this._oscemote = new OSCemote();
			this._oscemote.connect();
			
			this._waitEvent();
		}

		private function _waitEvent():void {
			event(this._teraClock, TeraClock.SECONDS_CHANGED, this._onSecond);
			event(this._base.stage, KeyboardEvent.KEY_DOWN, this._onKeyDown);
			event(this._oscemote, OSCemoteSliderEvent.SLIDER_CHANGE, this._onSliderChange);
			event(this._oscemote, OSCemoteSegmentEvent.SEGMENT_CHANGE, this._onSegmentChange);
			event(this._oscemote, OSCemoteSwitchEvent.STATE_CHANGE, this._onSwitchChange);
		}

		private function _onSecond(e:Event):void {
			this._generateRangeData();
			this._waitEvent();
		}

		private function _onKeyDown(e:KeyboardEvent):void {
			trace(e);
			switch (e.charCode) {
				case 49:
					this._waveTemplate.visible = !this._waveTemplate.visible;
					break;
				case 50:
					this._waveImage.visible = !this._waveImage.visible;
					break;
				case 51:
					this._contols.visible = !this._contols.visible;
					break;
			}
			this._waitEvent();
		}
		
		private function _onSliderChange(e:OSCemoteSliderEvent):void {
			switch (e.index) {
				case 1:
					this._rotationSlider.parameter.setValueNormalized(e.value);
					break;
				case 2:
					this._spacingSlider.parameter.setValueNormalized(e.value);
					break;
				case 3:
					this._scaleXSlider.parameter.setValueNormalized(e.value);
					break;
				case 4:
					this._scaleYSlider.parameter.setValueNormalized(e.value);
					break;
				case 5:
					this._lowerFreqSlider.parameter.setValueNormalized(e.value);
					break;
				case 6:
					this._upperFreqSlider.parameter.setValueNormalized(e.value);
					break;
			}
			this._waitEvent();
		}

		private function _onSegmentChange(e:OSCemoteSegmentEvent):void {
//			trace(e);
			this._waveKindSlider.parameter.setValue(e.value);
			this._waitEvent();
		}
		
		private function _onSwitchChange(e:OSCemoteSwitchEvent):void {
//			trace(e);
			switch (e.index) {
				case 1:
					this._waveTemplate.visible = e.state;
					break;
				case 2:
					this._waveImage.visible = e.state;;
					break;
				case 3:
					this._contols.visible = e.state;
					break;
			}
			this._waitEvent();
		}

		private function _generateRangeData():void {
			this._digits.update(this._teraClock);
			
			var template:BitmapData = this._waveTemplate.bitmapData;
			template.fillRect(template.rect, 0x0);
			template.draw(this._digits);
			
			var shape:Shape = new Shape();
			var g:Graphics = shape.graphics;
			g.clear();
			g.lineStyle(1, 0xffffff);
			g.moveTo(0, Constants.CANVAS_HEIGHT_HALF);
			var phase:Number = 0;
						
			var rect:Rectangle = template.getColorBoundsRect(0xffffff, 0x0, false);
			var tmp:BitmapData = new BitmapData(1, rect.height, false, 0x0);
			var tmpRect:Rectangle = new Rectangle(0, rect.top, 1, rect.height);
			var whiteRect:Rectangle;
			var range:RangeData;
			var i:int;
			for (i = 0;i < rect.left; i++) {
				range = this._data[i];
				range.min = range.max = 0;
			}
			g.lineTo(rect.left - 1, Constants.CANVAS_HEIGHT_HALF);
			for (i = rect.left;i < rect.right; i++) {
				tmpRect.x = i;
				tmp.copyPixels(template, tmpRect, ZERO_POINT);
				whiteRect = tmp.getColorBoundsRect(0xffffff, 0x0, false);
				range = this._data[i];
				if (whiteRect.top == whiteRect.bottom) {
					range.min = range.max = 0;
				} else {
					whiteRect.x += i;
					whiteRect.y += rect.top;
					range.min = (whiteRect.top - Constants.CANVAS_HEIGHT_HALF) / Constants.CANVAS_HEIGHT_HALF;
					range.max = (whiteRect.bottom - Constants.CANVAS_HEIGHT_HALF) / Constants.CANVAS_HEIGHT_HALF;
				}
				
				phase += 2.5;
				var sig:Number = Math.sin(phase);
				sig = sig > 0 ? 1 : -1;
				sig *= -range.diff * 0.5;
				sig -= range.center;
				g.lineTo(i, (1 - sig) * Constants.CANVAS_HEIGHT_HALF);
			}
			tmp.dispose();
			g.lineTo(rect.right + 1, Constants.CANVAS_HEIGHT_HALF);
			for (i = rect.right + 1;i < Constants.CANVAS_WIDTH; i++) {
				range = this._data[i];
				range.min = range.max = 0;
			}
			g.lineTo(Constants.CANVAS_WIDTH, Constants.CANVAS_HEIGHT_HALF);
			var bmp:BitmapData = this._waveImage.bitmapData;
			bmp.fillRect(bmp.rect, 0x0);
			bmp.draw(shape);
		}

		private function _onChangeRotation(parameter:Parameter, oldValue:*, newValue:*):void {
			this._digits.rotation = newValue;
			this._generateRangeData();
		}

		private function _onChangeSpacing(parameter:Parameter, oldValue:*, newValue:*):void {
			this._digits.spacingX = newValue;
			this._generateRangeData();
		}

		private function _onChangeScaleX(parameter:Parameter, oldValue:*, newValue:*):void {
			this._digits.scaleX = newValue;
			this._generateRangeData();
		}

		private function _onChangeScaleY(parameter:Parameter, oldValue:*, newValue:*):void {
			this._digits.scaleY = newValue;
			this._generateRangeData();
		}
		
		private function _onSampleData(e:SampleDataEvent):void {
			var osc:IOsc = this._oscilators[this._waveKindSlider.value];
			var lq:Number = this._lowerFreqSlider.value;
			var hq:Number = this._upperFreqSlider.value;
			var dq:Number = hq - lq;
			lq += dq + 0.5;
			for (var i:int = 0;i < 2048; i++) {
				var p:int = ((e.position + i) % 44100) / 44100 * this._data.length;
				var range:RangeData = this._data[p];
				this._freq = lq - range.center * dq;
				this._phase += PI2 * this._freq / 44100;
				var sig:Number = -osc.generate(this._phase) * range.diff * 0.5 - range.center;
				e.data.writeFloat(sig);
				e.data.writeFloat(sig);
			}
		}
	}
}
