package uranodai.oscemote {
	import it.h_umus.osc.OSCArgument;
	import it.h_umus.osc.OSCConnection;
	import it.h_umus.osc.OSCConnectionEvent;
	import it.h_umus.osc.OSCMessage;
	import it.h_umus.osc.OSCPacket;
	
	import uranodai.oscemote.event.OSCemoteAccelerationEvent;
	import uranodai.oscemote.event.OSCemoteButtonEvent;
	import uranodai.oscemote.event.OSCemoteSegmentEvent;
	import uranodai.oscemote.event.OSCemoteSliderEvent;
	import uranodai.oscemote.event.OSCemoteSwitchEvent;
	import uranodai.oscemote.event.OSCemoteTouchEvent;
	
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.events.IOErrorEvent;		

	public class OSCemote extends EventDispatcher
	{
		private var osc:OSCConnection;
		private var host:String;
		private var port:int;
		
		public function OSCemote(host:String="localhost", port:int=3000)
		{
			this.host = host;
			this.port = port;
			
			osc = new OSCConnection();
			osc.addEventListener(Event.CONNECT, trace);
			osc.addEventListener(Event.CLOSE, trace);
			osc.addEventListener(IOErrorEvent.IO_ERROR, trace);
			osc.addEventListener(OSCConnectionEvent.OSC_PACKET_IN, oscPacketInHandler);
		}
		
		public function connect():void
		{
			osc.connect(host, port);
		}
		
		public function close():void
		{
			osc.close();
		}
		
		private function oscPacketInHandler(e:OSCConnectionEvent):void
		{
			var packet:OSCPacket = e.data as OSCPacket;
//			trace('oscPacketInHandler ---------');
//			for each (var msg:OSCMessage in packet.messages) {
//				trace(msg.name);
//				for each (var args:OSCArgument in msg.arguments) {
//					trace('   ', args.type, '->', args.value);
//				}
//			}
			
			var msg0:OSCMessage = packet.messages[0];
			var names:Array = msg0.name.split('/');
//			trace(names);
			var ival:int;
			var fval:Number;
			var bval:Boolean;
			switch (names[1]) {
				case 'button':
					ival = int(OSCArgument(msg0.arguments[0]).value);
					var btnEv:OSCemoteButtonEvent = new OSCemoteButtonEvent(ival ? OSCemoteButtonEvent.BUTTON_DOWN : OSCemoteButtonEvent.BUTTON_UP, names[2]);
					this.dispatchEvent(btnEv);
					break;
				case 'slider':
					fval = Number(OSCArgument(msg0.arguments[0]).value);
					var sldEv:OSCemoteSliderEvent = new OSCemoteSliderEvent(OSCemoteSliderEvent.SLIDER_CHANGE, parseInt(names[2]), fval);
					this.dispatchEvent(sldEv);
					break;
				case 'segmented':
					ival = int(OSCArgument(msg0.arguments[0]).value);
					var segEv:OSCemoteSegmentEvent = new OSCemoteSegmentEvent(OSCemoteSegmentEvent.SEGMENT_CHANGE, ival);
					this.dispatchEvent(segEv);
					break;
				case 'switch':
					bval = Boolean(OSCArgument(msg0.arguments[0]).value);
					var swtEv:OSCemoteSwitchEvent = new OSCemoteSwitchEvent(OSCemoteSwitchEvent.STATE_CHANGE, parseInt(names[2]), bval);
					this.dispatchEvent(swtEv);
					break;
				case 'tuio':
					this.dispatchEvent(new OSCemoteTouchEvent(OSCemoteTouchEvent.TOUCH, packet));
					break;
				case 'acceleration':
					var x:Number = Number(OSCArgument(msg0.arguments[0]).value);
					var y:Number = Number(OSCArgument(msg0.arguments[1]).value);
					var z:Number = Number(OSCArgument(msg0.arguments[2]).value);
					var accEv:OSCemoteAccelerationEvent = new OSCemoteAccelerationEvent(OSCemoteAccelerationEvent.ACCELERATION_CHANGE, x, y, z);
					this.dispatchEvent(accEv);
					break;
			}
			
			
//			var packet:OSCPacket = e.data as OSCPacket;
//			var data:Array = [];
//			for each(var msg:OSCMessage in packet.messages){
//				trace(msg.name, '->', msg.arguments.length);
//				if(msg.name == OSCemoteMessage.TUIO_2DCUR){
//					onTuio2Dcur(msg, data);
//				}else if(msg.name == OSCemoteMessage.ACCELERATION_XYZ){
//					onAccelerationXYZ(msg, data);
//				}
//			}
//			if(data.length>0){
//				var event:OSCemoteEvent = new OSCemoteEvent(OSCemoteEvent.UPDATE);
//				event.data = data;
//				dispatchEvent(event);
//			}
		}
		
//		private function onTuio2Dcur(msg:OSCMessage, data:Array):void
//		{
//			var head:OSCArgument = msg.arguments[0] as OSCArgument;
//			if(head.value == OSCemoteArgument.SET){
//				data.push(new Tuio2Dcur(msg));
//			}
//		}
//		
//		private function onAccelerationXYZ(msg:OSCMessage, data:Array):void
//		{
//			data.push(new AccelerationXYZ(msg));
//		}

	}
}