﻿/**
* Knob
* @author zk(Takaaki Yamazaki)
* @version 0.1
*/

package org.sazameki.ui{
	import flash.display.GradientType;
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.filters.DropShadowFilter;
	import flash.geom.Matrix;
	import jp.zkdesign.utility.ColorUtility;
	import jp.zkdesign.utility.StageUtility;

	public class Knob extends AbstructGui{
		
		private var _callback:Function;
		private var _size:int;
		private var _color:int;
		private var _knobBg:Shape;
		private var _knob:Shape;
		
		private const MAX_DEGREE:int=135;
		private const MIN_DEGREE:int=-135;
		
		private var _isDown:Boolean;
		private var _prevY:Number;
		
		private var _value:Number;
		
		public function Knob(size:int = 30, knobColor:int = 0, callback:Function = null) {
			super();
			
			_callback=callback;
			_size=size;
			_color=knobColor;
			_isDown=false;
			
			_knobBg=new Shape();
			_knob=new Shape();
			
			draw();
			
			addChild(_knobBg);
			addChild(_knob);

			
			buttonMode=true;
			useHandCursor=true;
			addEventListener(MouseEvent.MOUSE_DOWN,onDown);

			
		}
		
		private function draw():void{
			//highlight color
			var bColor:int=ColorUtility.addColor(_color,0x60,0x60,0x60);
			var hColor:int=ColorUtility.addColor(_color,0x90,0x90,0x90);

			//45degree matrix
			var mtrx:Matrix=new Matrix();

			//draw background
			
			var g:Graphics=_knobBg.graphics;
			mtrx.createGradientBox(_size,_size,Math.PI/4,-_size,0);
			g.beginGradientFill(GradientType.LINEAR,[bColor,_color],[1,1],[0x00,0xFF],mtrx);
			g.drawCircle(0,0,_size/2);
			g.endFill();
			
			
			g.beginGradientFill(GradientType.LINEAR,[hColor,_color],[1,1],[0,255],mtrx);
			g.drawCircle(0,0,(_size/2)*0.8);
			g.endFill();
			
			
			mtrx.createGradientBox(_size,_size,0,-_size*0.7,-_size*0.7);
			g.beginGradientFill(GradientType.RADIAL,[hColor,_color],[1,1],[0,255],mtrx);
			g.drawCircle(0,0,(_size/2)*0.8-2);
			g.endFill();
			
			//add Shadow
			var shadow:DropShadowFilter=new DropShadowFilter(4,45,0,0.4,4,4);
			var filters:Array=_knobBg.filters;
			filters.push(shadow);
			_knobBg.filters=filters;
			
			//draw knob line
			
			g=_knob.graphics;
			g.beginFill(0xFFFFFF);
			g.drawRect(-2,-(_size/2)*0.8,4,(_size/2)*0.4);
			
		}
		
		
		private function onDown(e:MouseEvent):void{
			_isDown=true;
			_prevY=mouseY;
			StageUtility.getStage().addEventListener(MouseEvent.MOUSE_UP,onUp);
			StageUtility.getStage().addEventListener(MouseEvent.MOUSE_MOVE,onMove);
		}
		private function onMove(e:MouseEvent):void{
			if (_isDown)
			{
				var diff:Number = (_prevY - mouseY)*3;
				if (diff > 0)
				{
					_knob.rotation = Math.min(_knob.rotation + diff, MAX_DEGREE);
				}else if (diff < 0)
				{
					_knob.rotation = Math.max(_knob.rotation + diff, MIN_DEGREE);
				}
				_prevY=mouseY;
				updateValue();
			}
		}
		
		private function onUp(e:MouseEvent):void{
			_isDown=false;
			StageUtility.getStage().removeEventListener(MouseEvent.MOUSE_UP,onUp);
			StageUtility.getStage().removeEventListener(MouseEvent.MOUSE_MOVE,onMove);
		}
		
		
		private function updateValue():void{
			var r:Number=_knob.rotation;
			
			_value=(r-MIN_DEGREE)/(MAX_DEGREE-MIN_DEGREE);
			if(_callback!=null){
				_callback(_value);
			}
			if (_param)
			{
				_param.valueNormalized = _value;
			}
		}
		
		public function set valueNormalized(val:Number):void
		{
			_knob.rotation = MIN_DEGREE + val * (MAX_DEGREE - MIN_DEGREE);
			_value - val;
		}
		
	}
	
}
