﻿package org.sazameki.ui 
{
	import flash.display.Stage;
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.events.KeyboardEvent;
	import org.sazameki.events.NoteEvent;
	
	/**
	* ...
	* @author Takaaki Yamazaki(zk design)
	*/
	public class KeyboardKeyboard extends EventDispatcher
	{
		private var _stage:Stage;
		private var _octave:int;
		
		private var _noteMap:Object = {
			'90':1,//z
			'83':2,//s
			'88':3,//x
			'68':4,//d
			'67':5,//c
			'86':6,//v
			'71':7,//g
			'66':8,//b
			'72':9,//h
			'78':10,//n
			'74':11,//j
			'77':12,//m
			'81':13,//q
			'50':14,//2
			'87':15,//w
			'51':16,//3
			'69':17,//e
			'82':18,//r
			'53':19,//5
			'84':20,//t
			'54':21,//6
			'89':22,//y
			'55':23,//7
			'85':24,//u
			'73':25,//i
			'57':26,//9
			'79':27,//o
			'48':28,//0
			'80':29//p
		};
		private var _keyDown:Object=new Object();
		
		
		public function KeyboardKeyboard(stage:Stage,octave:int=3) 
		{
			_stage = stage;
			_octave = octave;
			
			_stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			_stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
		}
		
		private function onKeyDown(e:KeyboardEvent):void 
		{
			if (!_keyDown[String(e.keyCode)])
			{
				var _note:int = _noteMap[String(e.keyCode)];
				if (_note)
				{
					_keyDown[String(e.keyCode)] = true;
					var outputNote:int = _note + (12 * _octave) - 1;
					dispatchEvent(new NoteEvent(NoteEvent.NOTE_ON, outputNote));
				}
			}
		}
		
		
		private function onKeyUp(e:KeyboardEvent):void 
		{
			var _note:int = _noteMap[String(e.keyCode)];
			if (_note)
			{
				_keyDown[String(e.keyCode)] = false;
				var outputNote:int = _note + (12 * _octave) - 1;
				dispatchEvent(new NoteEvent(NoteEvent.NOTE_OFF, outputNote));
			}
		}
		

	}
	
}