﻿/*
 * --------------------------------------
 * sazameki -- audio manipulating library
 * http://sazameki.org/
 * --------------------------------------
 * 
 * - developed by     Takaaki Yamazaki
 *                    http://www.zkdesign.jp/
 * - supported by     Spark project
 *                    http://www.libspark.org/
 */


package org.sazameki.math.random {
	/**
	 * fast pseudo-random number generator using xorshift algorithm
	 * ported from: http://lucille.atso-net.jp/blog/?p=9;
	 * @author Takaaki Yamazaki
	 * @version 1.0
	 */ 
	public class XorshiftRandom {
		
		private var x:int=123456789;
		private var y:int=362436069;
		private var z:int=521288629;
		private var w:int=88675123;
		
		public function XorshiftRandom() {
		}
		public function generate():Number{
			var t:int;
			t=(x^(x<<11));
			x=y;
			y=z;
			z=w;
			return( w=(w^(w>>19))^(t^(t>>8)) );
		}
		public function geneNormalized():Number{
			generate();
			return(w/2147483648);
		}
	}
	
}
