﻿/*
 * --------------------------------------
 * sazameki -- audio manipulating library
 * http://sazameki.org/
 * --------------------------------------
 * 
 * - developed by     Takaaki Yamazaki
 *                    http://www.zkdesign.jp/
 * - supported by     Spark project
 *                    http://www.libspark.org/
 */

/*
 * Licensed under the MIT License
 * 
 * Copyright (c) 2008 Takaaki Yamazaki
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.sazameki.data {

	public class RingArray {
		
		private var _array:Array;
		private var _length:int;
		private var _idx:int;
		
		public function RingArray(length:int=10,defaultClass:Class=null) {
			_length=length;
			_array=new Array(length);
			if(defaultClass!=null){
				for(var i:int=0;i<_length;i++){
					_array[i]=new defaultClass();
				}
			}
			
			idx=-1;
		}
		
		public function push(obj:*):void{
			idx+=1;
			_array[idx]=obj;

		}
		
		public function getAt(index:int):*{
			//return values: _idx-index
			//index=0 -> return last pushed value
			var tmp:int=idx-index;
			tmp=tmp%_length;
			if(tmp<0){
				tmp=_length+tmp;
			}
			
			
			return(_array[tmp]);
			
		}
		
		private function set idx(num:int):void{
			
			num=num%_length;
			
			
			if(num<0){
				_idx=_length+num;
			}else{
				_idx=num;
			}

			
		}
		
		private function get idx():int{
			return _idx;
		}
		
		
		
		public function next():void{
			idx+=1;
		}
		
		public function prev():void{
			idx-=1;
		}
		
		public function toString():String{
			return(_array.toString());
		}
		
		public function get length():int{
			return _length;
		}
		
	}
	
}
