﻿/*
 * --------------------------------------
 * sazameki -- audio manipulating library
 * http://sazameki.org/
 * --------------------------------------
 * 
 * - developed by     Takaaki Yamazaki
 *                    http://www.zkdesign.jp/
 * - supported by     Spark project
 *                    http://www.libspark.org/
 */

/*
 * Licensed under the MIT License
 * 
 * Copyright (c) 2008 Takaaki Yamazaki
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.sazameki.audio.processor.envelope {
	import org.sazameki.audio.engine.ssGenerator.SsAudioSetting;
	import org.sazameki.audio.processor.SsAudioProcessor;

	/**
	* 直流に値する、常に一定の値を返すだけのエンベロープ。
	* @author Default
	* @version 0.1
	*/
	public class DC extends SsAudioProcessor implements IEnvelope{
		
		private var _val:Number=0;
		public function DC() {
			
		}
		override public function get description():String{
			return "DC envelope(always returns same value)"
		}
		override public function get parameterFormat():String{
			return 'level(0-1)'
		}
		override public function get isEnvelope():Boolean{ return true; }


		override public function initialize(setting:SsAudioSetting, basicParams:Array = null, additionalProcessors:Object = null):void{
			super.initialize(setting, basicParams, additionalProcessors);
			
			_val=basicParams[0];
		}
		
		public function defineEnvelope(value:Number):void{
			_val=value;
		}
		
		
		public function getEnvAt(idx:int):Number{
			return _val;
		}
		
		public function get length():int{
			return 1;
		}
	}
	
}
