﻿/*
 * --------------------------------------
 * sazameki -- audio manipulating library
 * http://sazameki.org/
 * --------------------------------------
 * 
 * - developed by     Takaaki Yamazaki
 *                    http://www.zkdesign.jp/
 * - supported by     Spark project
 *                    http://www.libspark.org/
 */

/*
 * Licensed under the MIT License
 * 
 * Copyright (c) 2008 Takaaki Yamazaki
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package org.sazameki.audio.processor.effects {
	import org.sazameki.audio.core.Sample;
	
	import org.sazameki.audio.engine.ssGenerator.SsAudioSetting;
	import org.sazameki.audio.processor.SsAudioProcessor;
	import org.sazameki.data.RingArray;
	import org.sazameki.math.random.XorshiftRandom;

	/**
	 * Reverb(under developing...)
	 * please tell me good and fast reverb algorithm ;-)
	 * @author Takaaki Yamazaki
	 * @version 0.1
	 */
	public class Reverb extends SsAudioProcessor{
		private const DELAY_COUNT_MAX:int=80;
		private const DELAY_TIME_MIN:Number=25;
		private const DELAY_TIME_MAX:Number=100;
		private const REV_COEFF:Number=0.2;
		private var _buffer:RingArray;
		private var _delayTimes:Array;
		private var _prevDelaysL:Array;
		private var _prevDelaysR:Array;
		private var _diffuse:Number;
		private var _length:Number;
		private var _feedback:Array;
		private var _pan:Array;
		private var _dry:Number;
		private var _wet:Number;
		private var _lpf:Number;
		private var _random:XorshiftRandom=new XorshiftRandom();
		
		public function Reverb() {
			
		}
		
		override public function get description():String{
			return "reverb effect."
		}
		override public function get parameterFormat():String{
			return 'reverb time(0-1)-diffuse(0-1)-richness(0-1)-low pass filter strength(0-1)-wet(0-1)-[dry(0-1)]'
		}
		
		override public function initialize(setting:SsAudioSetting, basicParams:Array = null, additionalProcessors:Object = null):void{
			super.initialize(setting, basicParams, additionalProcessors);
			
			//長さ(0-1)
			_length=basicParams[0];
			
			//Diffuse(広がり）
			_diffuse=basicParams[1];
			
			//リバーブのリッチさ（ディレイ音の数)(0-1)
			var cnt:int=Math.round(basicParams[2]*DELAY_COUNT_MAX);
			if(cnt<1){
				cnt=2;
			}
			
			//バッファの確保
			_buffer=new RingArray(Math.round(DELAY_TIME_MAX*setting.sampleRate/1000),Sample);
			//_buffer=new Array();


			//ディレイ音ごとのディレイタイムをランダムに設定
			
			_delayTimes=new Array();
			_prevDelaysR=new Array();
			_prevDelaysL=new Array();
			for(var i:int=0;i<cnt;i++){
				_delayTimes.push(
					Math.round(
						(_random.geneNormalized()*(DELAY_TIME_MAX-DELAY_TIME_MIN)+DELAY_TIME_MIN)*setting.sampleRate/1000
					)
				);
				_prevDelaysR.push(0);
				_prevDelaysL.push(0);
			}
			
			_delayTimes.sort(Array.NUMERIC);
	

			//フィードバック、PANの値を設定
			//
			//
			_feedback=new Array();
			_pan=new Array();
			var base:Number;
			var tmp:Number;
			//var buf:RingArray;
			var dTime:int;
			var diffusecoeff:Number=0.1;
			var n:int=Math.round(DELAY_TIME_MAX*setting.sampleRate/1000);
			for(var k:int=0;k<cnt;k++){
				dTime=_delayTimes[k];
				base=Math.min(((1-dTime/n)*(1-_length)+_length)*(_length/2),0.9);
				tmp=_random.geneNormalized()*_diffuse*diffusecoeff;
				_feedback[k]=Math.max(0,Math.min(base+tmp-(tmp/2),0.9));
				//R
				/*
				tmp=_random.geneNormalized()*_diffuse*diffusecoeff;
				_feedbackR[k]=Math.max(0,Math.min(base+tmp-(tmp/2),0.9));
				*/
				_pan[k]=((_random.geneNormalized()-0.5)*_diffuse)+0.5;
			}
			
			/*debug
			
			trace("DELAY_TIMES:"+_delayTimes);
			trace("BUFFER_LENGTH:"+_buffer.length);
			//*/
			
			//LPF強さ
			_lpf=basicParams[3];

			//mix量
			_wet=Number(basicParams[4]);
			_dry=Number(basicParams[5]);
			
			if(isNaN(_dry)){
				_dry=1-_wet;
			}
		}
		private var _test:Boolean=true;
		override public function processAudio(samples:Array):void{
			
			var inputSmpl:Sample;
			var bufferSmpl:Sample;
			var dryL:Number;
			var dryR:Number;
			var wetL:Number;
			var wetR:Number;
			var len:int=samples.length;
			var delayCount:int=_delayTimes.length;
			var k:int;
			var delayL:Number;
			var delayR:Number;

			for(var i:int=0;i<len;i++){
				//dry(input)
				inputSmpl=samples[i];
				dryL=inputSmpl.left;
				dryR=inputSmpl.right;
				
				
				wetR=0;
				wetL=0;
				
				//get and calc delays
				for(k=0;k<delayCount;k++){
					bufferSmpl=_buffer.getAt(_delayTimes[k]);
					
					delayL=bufferSmpl.left;
					delayR=bufferSmpl.right;
					
					//lpf
					
					delayL=delayL*(1-_lpf)+_prevDelaysL[k]*_lpf
					delayR=delayR*(1-_lpf)+_prevDelaysR[k]*_lpf;
					
					
					//feedback,pan
					
					delayL=delayL*_feedback[k]*_pan[k];
					delayR=delayR*_feedback[k]*(1-_pan[k]);
					
					//reverse phase
					delayL=-delayL;
					delayR=-delayR;
					
					wetL+=delayL;
					wetR+=delayR;			
					
					_prevDelaysL[k]=delayL;
					_prevDelaysR[k]=delayR;
				}
				//mix
				inputSmpl.left=dryL*_dry+wetL*_wet;
				inputSmpl.right=dryR*_dry+wetR*_wet;
				
				//update buffer
				bufferSmpl=_buffer.getAt(0);
				bufferSmpl.left=dryL+wetL*0.8;
				bufferSmpl.right=dryR+wetR*0.8;
				
				_buffer.next();
			
			}
			
			
			
			
		}
		
		
	}
	
}
