﻿/*
 * --------------------------------------
 * sazameki -- audio manipulating library
 * http://sazameki.org/
 * --------------------------------------
 * 
 * - developed by     Takaaki Yamazaki
 *                    http://www.zkdesign.jp/
 * - supported by     Spark project
 *                    http://www.libspark.org/
 */

/*
 * Licensed under the MIT License
 * 
 * Copyright (c) 2008 Takaaki Yamazaki
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package org.sazameki.audio.processor.effects {
	import org.sazameki.audio.core.Sample;
	import org.sazameki.audio.engine.ssGenerator.SsAudioSetting;
	import org.sazameki.audio.processor.SsAudioProcessor;

	public class Limiter extends SsAudioProcessor {
		
		private var _limitLevel:Number;
		
		public function Limiter() {
			
		}
		override public function get description():String{
			return "super simple limiter."
		}
		override public function get parameterFormat():String{
			return 'limit level(0-1)'
		}
		
		override public function initialize(setting:SsAudioSetting, basicParams:Array = null, additionalProcessors:Object = null):void{
			super.initialize(setting, basicParams, additionalProcessors);
			
			
			_limitLevel=basicParams[0];
			if(isNaN(_limitLevel)){
				_limitLevel=1;
			}
			if(Math.abs(_limitLevel)>1){
				_limitLevel=1;
			}
			
			_limitLevel=Math.abs(_limitLevel);
			
		}
		
		
		override public function processAudio(samples:Array):void{
			var smpl:Sample;
			var len:int=samples.length;
			var sig:Number;
			
			for(var i:int=0;i<len;++i){
				smpl=samples[i];
				
				sig=smpl.left;
				
				if(sig>_limitLevel){
					smpl.left=_limitLevel;
				}else if(sig<-_limitLevel){
					smpl.left=-_limitLevel;
				}
				
				sig=smpl.right;
				
				if(sig>_limitLevel){
					smpl.right=_limitLevel;
				}else if(sig<-_limitLevel){
					smpl.right=-_limitLevel;
				}
			}
		}
		
		
	}
	
}
