﻿package org.sazameki.audio.parameter 
{
	
	/**
	* ...
	* @author Takaaki Yamazaki(zk design)
	*/
	public class ParameterExponential extends Parameter
	{
		
		private var _num0:Number;
		public function ParameterExponential(min:Number,max:Number) 
		{
			super(min, max);
			if (_min == 0)
			{
				//TODO:minが0でも大丈夫なようにする
				throw(new Error("'min' parameter must not be 0"));
			}
			_num0 = Math.log(max / min);
		}
		
		override public function get valueNormalized():Number 
		{
			return Math.log(_value/_min)/_num0;
		}
		
		override public function set valueNormalized(value:Number):void 
		{
			if (value <= 0)
			{
				_value = _min;
				return;
			}
			if (value >= 1)
			{
				_value = _max;
				return;
			}
			
			_value = _min * Math.exp(_num0 * value);
			//trace(_value);
		}
		
	}
	
}