﻿package org.sazameki.audio.format.wav {
	import flash.utils.ByteArray;
	import flash.utils.Endian;
	import org.sazameki.audio.core.AudioSamples;
	import org.sazameki.audio.core.AudioSetting;
	import org.sazameki.audio.format.riff.Chunk;
	import org.sazameki.audio.format.riff.RIFF;
	import org.sazameki.audio.format.wav.chunk.WavdataChunk;
	import org.sazameki.audio.format.wav.chunk.WavfmtChunk;
	
	public class Wav extends RIFF{

		public function Wav() {
			super('WAVE');
		}
		
		public function encode(samples:AudioSamples):ByteArray
		{
			var fmt:WavfmtChunk = new WavfmtChunk();
			var data:WavdataChunk = new WavdataChunk();

			_chunks = new Vector.<Chunk>;
			_chunks.push(fmt);
			_chunks.push(data);

			data.setAudioData(samples);
			fmt.setSetting(samples.setting);
			
			return toByteArray();
		}
		
		public function decode(wavData:ByteArray):AudioSamples
		{
			var obj:Object = splitList(wavData);
			if(obj['fmt '] && obj['data']){
				var fmt:WavfmtChunk = new WavfmtChunk();
				var setting:AudioSetting = fmt.decodeData(obj['fmt '] as ByteArray);
				
				var data:WavdataChunk = new WavdataChunk();
				return data.decodeData(obj['data'] as ByteArray, setting);
			}else
			{
				throw(new Error('invalid wav file'));
				return null;
			}
		}
	}
	
}