﻿package org.sazameki.audio.format.riff 
{
	import flash.utils.ByteArray;
	import flash.utils.Endian;
	
	/**
	* RIFF Chunk class
	* @author Takaaki Yamazaki(zk design)
	*/
	public class Chunk 
	{
		protected const ENDIAN:String = Endian.LITTLE_ENDIAN;
		protected var _id:String;
		
		public function Chunk(id:String) 
		{
			this.id = id;
		}
		public function get id():String { return _id; }
		
		public function set id(value:String):void 
		{
			if (value.length > 4)
			{
				value = value.substr(0, 4);
			}else if (value.length < 4)
			{
				while (value.length < 4)
				{
					value += " ";
				}
			}
			_id = value;
		}
		
		
		public function toByteArray():ByteArray
		{
			//encode data bytes
			var data:ByteArray = encodeData();
			//
			var result:ByteArray = new ByteArray();
			result.endian = ENDIAN;
			//write chunk header
			result.writeUTFBytes(_id);
			//write data length
			result.writeUnsignedInt(data.length);
			//write data
			result.writeBytes(data);
			
			return result;
		}
		
		protected function encodeData():ByteArray
		{
			//require overriden
			throw(new Error('"encodeData()" method require overriden'));
		}
		
		
		
		
	}
	
}