﻿package org.sazameki.audio.engine.tenoran
{
	import flash.display.DisplayObject;
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.utils.setTimeout;
	import jp.zkdesign.utility.StageUtility;
	/**
	* ...
	* @author Takaaki Yamazaki(zk design)
	*/
	public class TenoranUI extends Sprite
	{
		[Embed(source = "assets/ui.png")]
		private var Bg:Class;

		private var btns:Vector.<Vector.<TenoranBtn>>;
		
		private var tenoran:Tenoran;
		
		private const btnSize:Number = 25;
		private const btnOffsetX:Number = 48;
		private const btnOffsetY:Number = 48;
		
		private var bpmTf:TextField;
		private var swingTf:TextField;
		
		internal var isMouseDown:Boolean=false;
		
		public function TenoranUI(tenoran:Tenoran) 
		{
			this.tenoran = tenoran;
			
			//create background
			addChild(new Bg() as DisplayObject);
			btns=new Vector.<Vector.<TenoranBtn>>(16);
			//create btns
			for (var i:int = 0; i < 16; ++i )
			{
				btns[i] = new Vector.<TenoranBtn>(16);
				for (var k:int = 0; k < 16; ++k)
				{
					var btn:TenoranBtn = new TenoranBtn(i, k, this);
					
					btn.x = btnSize * i + btnOffsetX;
					btn.y = btnSize * k + btnOffsetY;
					addChild(btn);
					btns[i][k] = btn;
				}
			}
			
			//texts
			var tf:TextFormat = new TextFormat("_sans",18,0,true);
			
			bpmTf = new TextField();
			bpmTf.defaultTextFormat = tf;
			bpmTf.text = String(tenoran.bpm);
			bpmTf.x = 190;
			bpmTf.y = 475;
			addChild(bpmTf);
			
			swingTf = new TextField();
			swingTf.defaultTextFormat = tf;
			swingTf.text = String(tenoran.swing);
			swingTf.width = 40;
			swingTf.x = 290;
			swingTf.y = 475;
			addChild(swingTf);
			
			
			//cerate ctrlBtns
			var bpmAddBtn:TenoranCtrlBtn = new TenoranCtrlBtn();
			bpmAddBtn.addEventListener(MouseEvent.CLICK, onBpmAdd);
			bpmAddBtn.x = 50;
			bpmAddBtn.y = 485;
			addChild(bpmAddBtn);
			
			var bpmSubBtn:TenoranCtrlBtn = new TenoranCtrlBtn();
			bpmSubBtn.addEventListener(MouseEvent.CLICK, onBpmSub);
			bpmSubBtn.x = 80;
			bpmSubBtn.y = 485;
			addChild(bpmSubBtn);
			
			var swingAddBtn:TenoranCtrlBtn = new TenoranCtrlBtn();
			swingAddBtn.addEventListener(MouseEvent.CLICK, onSwingAdd);
			swingAddBtn.x = 120;
			swingAddBtn.y = 485;
			addChild(swingAddBtn);
			
			var swingSubBtn:TenoranCtrlBtn = new TenoranCtrlBtn();
			swingSubBtn.addEventListener(MouseEvent.CLICK, onSwingSub);
			swingSubBtn.x = 150;
			swingSubBtn.y = 485;
			addChild(swingSubBtn);
			
			var resetBtn:TenoranCtrlBtn = new TenoranCtrlBtn();
			resetBtn.addEventListener(MouseEvent.CLICK, onReset);
			resetBtn.x = 484;
			resetBtn.y = 80;
			addChild(resetBtn);
			
			addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
			StageUtility.getStage().addEventListener(MouseEvent.MOUSE_UP, onMouseUp);

		}
		
		private function onReset(e:MouseEvent):void 
		{
			var btn:TenoranBtn;
			for (var i:int = 0; i < 16;++i)
			{
				for (var k:int = 0; k < 16; ++k)
				{
					btn = btns[i][k];
					btn.isOn = false;
				}
			}
		}
		
		private function onMouseDown(e:MouseEvent):void 
		{
			isMouseDown = true;
		}
		
		private function onMouseUp(e:MouseEvent):void 
		{
			isMouseDown = false;
		}
		
		private function onSwingSub(e:MouseEvent):void 
		{
			tenoran.swing -= 0.1;
			swingTf.text = String(Math.round(tenoran.swing*10)/10);
		}
		
		private function onSwingAdd(e:MouseEvent):void 
		{
			tenoran.swing += 0.1;
			swingTf.text = String(Math.round(tenoran.swing*10)/10);
		}
		
		private function onBpmSub(e:MouseEvent):void 
		{
			tenoran.bpm -= 5;
			bpmTf.text = String(tenoran.bpm);
		}
		
		private function onBpmAdd(e:MouseEvent):void 
		{
			tenoran.bpm += 5;
			bpmTf.text = String(tenoran.bpm);
		}
		
		public function getOnNotes(xIdx:int):Vector.<int> {
			var result:Vector.<int>=new Vector.<int>();
			var current:Vector.<TenoranBtn>=btns[xIdx];
			for (var i:int = 0; i < 16; ++i)
			{
				if (current[i].isOn)
				{
					result.push(i);
				}
			}
			return result;
		}
		
		public function activateLine(idx:int,latency:int):void
		{
			setTimeout(lineOn, latency, idx);
		}
		private function lineOn(idx:int):void
		{
			var current:Vector.<TenoranBtn>=btns[idx];
			for (var i:int = 0; i < 16; ++i)
			{
				current[i].lightOn();
			}
		}
		
		public function allOff():void
		{
			
		}
	}
}