﻿/*
 * --------------------------------------
 * sazameki -- audio manipulating library
 * http://sazameki.org/
 * --------------------------------------
 * 
 * - developed by     Takaaki Yamazaki
 *                    http://www.zkdesign.jp/
 * - supported by     Spark project
 *                    http://www.libspark.org/
 */

/*
 * Licensed under the MIT License
 * 
 * Copyright (c) 2008 Takaaki Yamazaki
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package org.sazameki.audio.engine.ssGenerator.processor {
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.events.TimerEvent;
	import flash.utils.Timer;
	import org.sazameki.audio.core.AudioSetting;
	import org.sazameki.audio.processor.ISsAudioProcessor;
	import org.sazameki.audio.processor.SsAudioProcessor;
	

	public class MasterProcessor extends SsAudioProcessor implements IMasterProcessor{
		
		private var _id:String;
		private var _processorsChain:Array;
		private var _isMaster:Boolean = false;
		private var _resultArray:Array;
		private var _timer:Timer;
		
		public function MasterProcessor(id:String){
			_id=id;
			_isMaster=(id=='master');
			_processorsChain=new Array();
		}
		
		public function add(p:ISsAudioProcessor):void{
			if(p){
				_processorsChain.push(p);
			}
		}
		public function addSubProcessor(id:String,p:IMasterProcessor):void{
			if(p){
				//参照を保持
				MasterProcessorReference.setReference(id,p);
				_processorsChain.push(p);
			}
			
		}
		public function start():void{
			//各AudioProcessorのidxを最初に戻す
			trigger();
			_resultArray=new Array();
			if(_setting.samplesPerUpdate==0){
				//PerFrameがゼロの場合は一回起動のみ。
				processAudio(_resultArray);
				dispatchEvent(new Event(Event.COMPLETE));
			}else if(_setting.samplesPerUpdate>0){
				//ゼロより大きければ終わるまで200msごとに処理
				_timer=new Timer(100);
				_timer.addEventListener(TimerEvent.TIMER,onTimerTriggered);
				_timer.start();
			}
			
			
		}

		private function onTimerTriggered(e:TimerEvent):void{
			var arr:Array=new Array();
			processAudio(arr);
			if(arr.length>0){
				_resultArray=_resultArray.concat(arr);
			}else{
				//追加されるsampleがない＝生成完了と判断
				//イベント発行
				dispatchEvent(new Event(Event.COMPLETE));
				//リスナー削除
				_timer.removeEventListener(TimerEvent.TIMER,onTimerTriggered);
			}
		}
		
		override public function trigger():void{
			var len:int=_processorsChain.length;
			for(var i:int=0;i<len;i++){
				(_processorsChain[i] as ISsAudioProcessor).trigger();
			}
		}
		
		
		override public function processAudio(smpl:Array):void{
			var len:int=_processorsChain.length;
			
			if(!_isMaster){
				_resultArray=new Array();
			}
			
			for(var i:int=0;i<len;i++){
				if(_isMaster){
					(_processorsChain[i] as ISsAudioProcessor).processAudio(smpl);
				}else{
					(_processorsChain[i] as ISsAudioProcessor).processAudio(_resultArray);
				}
			}
		}
		
		public function get result():Array{
			return _resultArray;
		}
		public function get id():String{
			return _id;
		}
		
	}
	
}
