﻿/*
 * --------------------------------------
 * sazameki -- audio manipulating library
 * http://sazameki.org/
 * --------------------------------------
 * 
 * - developed by     Takaaki Yamazaki
 *                    http://www.zkdesign.jp/
 * - supported by     Spark project
 *                    http://www.libspark.org/
 */

/*
 * Licensed under the MIT License
 * 
 * Copyright (c) 2008 Takaaki Yamazaki
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package org.sazameki.audio.engine.ssGenerator.engine {
	import org.sazameki.audio.core.SoundFactory;
	import org.sazameki.audio.processor.effects.Delay;
	import org.sazameki.audio.processor.effects.Distortion;
	import org.sazameki.audio.processor.effects.Limiter;
	import org.sazameki.audio.processor.effects.Reverb;
	import org.sazameki.audio.processor.effects.Stereo;
	import org.sazameki.audio.processor.envelope.ADSHR;
	import org.sazameki.audio.processor.envelope.DADSHR;
	import org.sazameki.audio.processor.envelope.DC;
	import org.sazameki.audio.processor.envelope.FreeEnv;
	import org.sazameki.audio.processor.filter.FormantFilter;
	import org.sazameki.audio.processor.filter.MoogVCF;
	import org.sazameki.audio.processor.filter.SimpleLPF;
	import org.sazameki.audio.processor.ISsAudioProcessor;
	import org.sazameki.audio.processor.mixer.Mixer;
	import org.sazameki.audio.processor.oscillator.SineOsc;
	import org.sazameki.audio.processor.oscillator.SquareOsc;
	import org.sazameki.audio.processor.oscillator.SawOsc;
	import org.sazameki.audio.processor.oscillator.NoiseOsc;
	import org.sazameki.audio.processor.oscillator.TriOsc;
	import org.sazameki.audio.processor.utility.LengthChanger;

	public class EngineMax extends EngineBase {
		
		
		public function EngineMax(smplPerUpdate:int=0,optionalSoundFactory:SoundFactory=null) {
			super(smplPerUpdate,optionalSoundFactory);
			
			audioProcessors={
				l:LengthChanger,
				g_sine:SineOsc,
				g_square:SquareOsc,
				g_saw:SawOsc,
				g_tri:TriOsc,
				g_noise:NoiseOsc,
				
				e_vcf:MoogVCF,
				e_lpf:SimpleLPF,
				e_formant:FormantFilter,
				
				adshr:ADSHR,
				dc:DC,
				dadshr:DADSHR,
				free:FreeEnv,
				
				m_mix:Mixer,
				
				e_vcf:MoogVCF,
				e_delay:Delay,
				e_limit:Limiter,
				e_stereo:Stereo,
				e_reverb:Reverb,
				e_dist:Distortion

			};
			
		}
		

		
		

	}
	
}
