﻿package org.sazameki.audio.engine.MultiSamplePlayer 
{
	import org.sazameki.audio.core.AudioSamples;
	import org.sazameki.audio.utils.FrequencyUtil;
	
	/**
	* ...
	* @author Takaaki Yamazaki(zk design)
	*/
	public class Voice 
	{

		private var _phase:Number;
		private var _phaseAdd:Number=1;
		private var _inst:Instrument;
		private var _note:uint;
		private var _finish:Boolean = false;
		private var _noteOff:Boolean = false;
		private var _noteOnOffset:int;
		private var _noteOffOffset:int;
		private var _sampleLength:int;
		private var _velocity:Number;
		private var _fadeOutSpeed:Number = 0.01;
		
		public function Voice(inst:Instrument,noteNum:uint,startOffset:uint=0,velocity:Number=0.8) 
		{
			_inst = inst;
			_note = noteNum;
			_noteOnOffset = startOffset;
			_sampleLength = inst.samples.length;
			
			_phase = 0;
			
			if(inst.sampleNote!=255){
				var f:Function = FrequencyUtil.midiNoteToFreq;
				_phaseAdd = f(noteNum) / f(inst.sampleNote);
			}
			_velocity = velocity;
		}
		public function get finish():Boolean{ return _finish; }
		public function get note():uint { return _note; }
		public function get noteOffStat():Boolean { return _noteOff; }
		public function noteOff(offset:int):void
		{
			_noteOff = true;
			_noteOffOffset = offset;
		}

		
		public function process(samples:AudioSamples):void
		{
			//普通にループだけしみてる
			/*
			var len:int = samples.length;
			var left:Vector.<Number>=samples.left;
			var right:Vector.<Number>=samples.right;
			var instLeft:Vector.<Number>=_inst.samples.left;
			var sig:Number;
			var loopEnd:int=_inst.loopEnd;
			var loopStart:int = _inst.loopStart;
			trace(loopStart);
			for (var i:int = 0; i < len; ++i)
			{
				sig = instLeft[_phase];
				left[i] = sig;
				right[i] = sig;

				_phase += 1;
			
				if (_phase >= loopEnd)
				{
					_phase = loopStart;
				}
			}
			//*/
		
			//*
			var loopStart:int = _inst.loopStart;
			var loopEnd:int = _inst.loopEnd;
			var loopLength:int = loopEnd - loopStart;
			var len:int = samples.length;
			var i:int = 0;
			var nearIdx:int;
			var diff:Number;
			var instChannels:int = _inst.samples.setting.channels;
			var bufferChannels:int = samples.setting.channels;
			var bufLeft:Vector.<Number>=samples.left;
			var bufRight:Vector.<Number>=samples.right;
			var instLeft:Vector.<Number>=_inst.samples.left;
			var instRight:Vector.<Number>=_inst.samples.right;
			var instLen:int = instLeft.length;
			var prev:Number;
			var next:Number;
			var tmpLeft:Number;
			
			for (i=0; i < len; ++i)
			{
				if (_noteOnOffset == 0)
				{
					nearIdx = Math.floor(_phase);
					diff = _phase - nearIdx;
					if (diff != 0)
					{
						//補間する。とりあえずシンプルに線形補間で試してみる。
						prev = instLeft[nearIdx];
						
						if(loopEnd){
							if (nearIdx+1 < loopEnd)
							{
								next = instLeft[nearIdx + 1];
							}else
							{
								next = instLeft[loopStart];
							}
						}else
						{
							if (nearIdx + 1 < instLen)
							{
								next = instLeft[nearIdx + 1];
							}else
							{
								next = 0;
							}
						}
						tmpLeft = (prev + (next - prev) * diff) * _velocity;
						
						bufLeft[i] += tmpLeft;
						
						if (bufferChannels == 2)
						{
							if (instChannels == 2)
							{
								prev = instRight[nearIdx];
								if (loopEnd)
								{
									if (nearIdx < loopEnd)
									{
										next = instRight[nearIdx + 1];
									}else
									{
										next = instRight[loopStart];
									}
								}else
								{
									if (nearIdx + 1 < instLen)
									{
										next = instLeft[nearIdx + 1];
									}else
									{
										next = 0;
									}
								}
								bufRight[i] += (prev+(next-prev) * diff)*_velocity;
							}else
							{
								bufRight[i] += tmpLeft;
							}
						}
					}else
					{
						bufLeft[i] += instLeft[nearIdx]*_velocity;
						if (bufferChannels == 2)
						{
							bufRight[i] += (instChannels == 2) ? instRight[nearIdx]*_velocity : instLeft[nearIdx]*_velocity;
						}
					}
					_phase += _phaseAdd;
					if (loopEnd)
					{
						if (_phase > loopEnd)
						{
							_phase -= loopLength;
						}
					}else
					{
						if (_phase >= _sampleLength)
						{
							_finish = true;
							return;
						}
					}
					
					if (_noteOff)
					{
						if (--_noteOffOffset < 0)
						{
							if(_velocity<=0){
								_finish = true;
								return;
							}

							//denoise
							_velocity = Math.max(_velocity-_fadeOutSpeed,0);

						}
					}
				}else
				{
					_noteOnOffset--;
				}

				
			}
			//*/
			
			
		}
		
		
	}
	
}