﻿package org.sazameki.audio.engine.MultiSamplePlayer 
{
	import org.sazameki.audio.core.AudioSamples;
	import org.sazameki.audio.core.AudioSetting;
	import org.sazameki.audio.ctrlEvent.CtrlEventList;
	
	/**
	* ...
	* @author Takaaki Yamazaki(zk design)
	*/
	public class ProcessData 
	{
		
		private var _samples:AudioSamples;
		private var _events:CtrlEventList;
		private var _length:int;
		
		public function ProcessData(length:uint=512) 
		{
			_length = length;
			_samples = new AudioSamples(new AudioSetting(), length);
			_events = new CtrlEventList(length);
		}
		public function get events():CtrlEventList { return _events; }
		public function get samples():AudioSamples { return _samples; }
		public function get length():int { return _length; }
		
		public function clearAudio():void
		{
			_samples.clearSamples();
		}
		public function clearEvents():void
		{
			_events = new CtrlEventList(_length);
		}
		
		
	}
	
}