﻿/*
 * --------------------------------------
 * sazameki -- audio manipulating library
 * http://sazameki.org/
 * --------------------------------------
 * 
 * - developed by     Takaaki Yamazaki
 *                    http://www.zkdesign.jp/
 * - supported by     Spark project
 *                    http://www.libspark.org/
 */

/*
 * Licensed under the MIT License
 * 
 * Copyright (c) 2008 Takaaki Yamazaki
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


/**
* Audio Setting Class
* stores audio setting like sample rate,bit rate,channels
* @author Takaaki Yamazaki
* @version 0.1
*/

package org.sazameki.audio.core {

	public class AudioSetting {
		
		private var _channels:uint;
		private var _sampleRate:uint;
		private var _sampleRateIndex:uint;
		private var _bitRate:uint;

		
		public function AudioSetting(channels:uint=2,sampleRate:uint=44100,bitRate:uint=16) {
			//TODO: throw error if not valid value passed.
			
			if(sampleRate==44100){
				_sampleRateIndex=3;
			}else if(sampleRate==22050){
				_sampleRateIndex=2;
			}else if(sampleRate==11025){
				_sampleRateIndex=1;
			}else{
				throw(new Error("bad sample rate. sample rate must be 44100,22050,11025"));
			}
			
			if(!(channels==1 || channels==2)){
				throw(new Error("channels must be 1 or 2"));
			}
			
			if(!(bitRate==16 || bitRate==8)){
				throw(new Error("bitRate must be 8 or 16"));
			}
			_channels=channels;
			_sampleRate=sampleRate;
			_bitRate=bitRate;
		}
		
		public function get channels():uint{
			return _channels;
		}
		
		public function get sampleRate():uint{
			return _sampleRate;
		}
		
		public function get bitRate():uint{
			return _bitRate;
		}
		
		public function get sampleRateIndex():uint { return _sampleRateIndex; }
		
		

	}
	
}
