import mx.utils.Delegate;
import caurina.transitions.Tweener;
import flash.display.BitmapData;
import flash.geom.Matrix;
import flash.geom.Rectangle;
/**
 * @author Saqoosha
 */
class App extends MovieClip {

	/**
	 * Entry point
	 */
	public static function main(mc:MovieClip):Void {
		Stage.align = "TL";
		Stage.scaleMode = "noScale";
		mc._quality = 'BEST';  // これがポイントね。。
		mc._focusRect = false;
		mc.__proto__ = App.prototype;
		Function(App).apply(mc, null);
	}
	
	private var _currentIndex:Number = 1;
	private var _photo:MovieClip;
	private var _zoomRect:Rectangle;
	
	private var _qText:TextField;
	private var _qStr = ['LOW', 'MEDIUM', 'HIGH', 'BEST'];
	private var _qIdx = 3;
	
	/**
	 * Constructor
	 */
	private function App() { // こっから始まる
		this._qText = this.createTextField('q', 100, 10, 10, 100, 30);
		this._qText.setNewTextFormat(new TextFormat('Verdana', 16, 0xffffff, true));
		this._qText.text = this._quality;
		Mouse.addListener({
			onMouseDown: Delegate.create(this, this._changeQuallity) // MouseDown で _changeQuallity
		});
		this._nextPhoto(); // はじまりはじまりー
	}
	
	private function _changeQuallity():Void { // _quality 変える。
		this._quality = this._qText.text = this._qStr[this._qIdx++];
		this._qIdx = this._qIdx % 4;
		trace(this._quality);
	}
	
	private function _nextPhoto():Void {
		this._photo = this.createEmptyMovieClip('loader', 1); // 読み込む用のん
		this._photo._visible = false; // 見えないように
		this._photo.loadMovie('images/' + this._currentIndex +'.jpg');
		this.onEnterFrame = this._loadCheck; // 読み込みチェックしまーす
	}
	
	private function _loadCheck():Void { // 読み込みチェックしまーす
		var loaded:Number = this._photo.getBytesLoaded();
		var total:Number = this._photo.getBytesTotal();
		if (total > 0 && loaded == total) { // 読み込み完了
			delete this.onEnterFrame; // 読み込みチェックやめまーす
			var bm:BitmapData = new BitmapData(this._photo._width, this._photo._height, false, 0xf0); // BitmapData に draw しなおします。
			bm.draw(this._photo);
			this._photo.unloadMovie(); // 読み込みようのんはいらん。
			this._photo.removeMovieClip(); // 捨てます。
			this._photo = this.createEmptyMovieClip('photo', 1); // 表示用のんをあらたに作る
			this._photo._alpha = 0; // とりあえず消しとく
			this._photo.attachBitmap(bm, 1, 'auto', true); // draw したやつを attach。さいごの true が重要。
			this._zoomRect = new Rectangle(0, 0, this._photo._width, this._photo._height); // どこを拡大するか？
			Tweener.addTween(this._photo, { // 最初のフェードイン
				_alpha: 100,
				time: 3,
				transition: 'easeInOutCubic'
			});
			Tweener.addTween(this._zoomRect, { // ズーム用の Rectangle のパラメータをアニメーションさせる
				width: this._photo._width * 0.8, // パラメータの意味は図で説明せんとわからんだろうなあ。。。
				height: this._photo._height * 0.8,
				x: Math.random() * this._photo._width * 0.2,
				y: Math.random() * this._photo._height * 0.2,
				time: 15,
				transition: 'easeNone',
				onComplete: Delegate.create(this, this._cleanup) // アニメがおわったらおかたずけ
			});
			Tweener.addTween(this._photo, { // 最初のフェードイン
				_alpha: 0,
				time: 3,
				delay: 12,
				transition: 'easeInOutCubic'
			});
			this.onEnterFrame = this._adjustSize; // _zoomRect のアニメを実際の画像に毎フレーム適用する。
		}
	}
	
	private function _adjustSize():Void { // _zoomRect の値をもとに、実際の表示サイズと位置を計算する 
		var s:Number = this._photo._xscale = this._photo._yscale = Math.max((Stage.width / this._zoomRect.width), (Stage.height / this._zoomRect.height)) * 100;
		s /= 100;
		this._photo._x = (Stage.width - this._zoomRect.width * s) / 2 - this._zoomRect.x * s;
		this._photo._y = (Stage.height - this._zoomRect.height * s) / 2 - this._zoomRect.y * s;
	}
	
	private function _cleanup():Void { // おかたずけしましょう
		delete this.onEnterFrame; // もう計算しなくていいよ
		if (++this._currentIndex == 5) { // 次の画像番号に
			this._currentIndex = 1;
		}
		this._nextPhoto(); // 次、はじめまーす
	}

}
