package {
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.utils.ByteArray;
	
	import net.hires.controllers.VideoController;
	import net.saqoosha.colorlog.ColorLog;
	import net.saqoosha.colorlog.SGR;
	
	[SWF(width=320, height=136, backgroundColor=0x0, frameRate=10)]

	public class TestColorLog5 extends Sprite {
		
		private static const COLORS:Array = [
			SGR.BG_NORMAL_BLACK,
			SGR.BG_BRIGHT_BLUE,
			SGR.BG_BRIGHT_GREEN,
			SGR.BG_BRIGHT_CYAN,
			SGR.BG_BRIGHT_RED,
			SGR.BG_BRIGHT_MAGENTA,
			SGR.BG_BRIGHT_YELLOW,
			SGR.BG_BRIGHT_WHITE
		];
		
		private var _canvas:BitmapData;
		private var _video:VideoController;
		private var _drawMatrix:Matrix;
		private var _outRect:Rectangle;
		
		public function TestColorLog5() {
			ColorLog.hideCursor();
			
			this._canvas = new BitmapData(100, 49, false, 0);
			var b:Bitmap = new Bitmap(this._canvas);
			b.scaleX = 5;
			b.scaleY = 10;
//			this.addChild(b);
			
			this._video = new VideoController(320, 136);
			this._video.load('wolverine-clip_h.320.mp4');
			this._video.play();
			this.addChild(this._video);
			this._drawMatrix = new Matrix(100 / 320, 0, 0, 100 / 320 * 0.5, 0, 0);
			this._outRect = new Rectangle(0, 0, int(320 * this._drawMatrix.a), int(136 * this._drawMatrix.d));

			this.addEventListener(Event.ENTER_FRAME, this._update);
		}
		
		private function _update(e:Event):void {
			ColorLog.clearScreen();
			this._canvas.draw(this._video, this._drawMatrix);
			this.drawBitmap(this._canvas, this._outRect);
			ColorLog.flush();
		}
		
		private function drawBitmap(bmp:BitmapData, rect:Rectangle, dest:Point = null):void {
			var b:ByteArray = bmp.getPixels(rect);
			for (var y:int = 0; y < rect.height; y++) {
				ColorLog.moveTo(y + 1, 1);
				for (var x:int = 0; x <rect.width; x++) {
					var p:int = (y * rect.width + x) * 4;
					var c:int = (b[p + 1] & 0x80) ? 0x4 : 0;
					c |= (b[p + 2] & 0x80) ? 0x2 : 0;
					c |= (b[p + 3] & 0x80) ? 0x1 : 0;
					ColorLog.setColor(COLORS[c]);
					ColorLog.out(' ');
				}
			}
		}
	}
}