package {
	
	import com.trick7.utils.TeraClock;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	
	import net.saqoosha.colorlog.ColorLog;
	import net.saqoosha.colorlog.SGR;
	
	[SWF(width=500, height=500, backgroundColor=0x0, frameRate=15)]

	public class TestColorLog3 extends Sprite {
		
		private var _canvas:BitmapData;
		private var _clock:TeraClock;
		
		public function TestColorLog3() {
			ColorLog.hideCursor();
			
			this._canvas = new BitmapData(100, 50, false, 0);
			var b:Bitmap = new Bitmap(this._canvas);
			b.scaleX = 5;
			b.scaleY = 10;
			this.addChild(b);
			
			this._clock = new TeraClock();
			this._clock.addEventListener(TeraClock.SECONDS_CHANGED, this._update);
		}
		
		private function _update(e:Event):void {
			ColorLog.clearScreen();
			this._canvas.fillRect(this._canvas.rect, 0x0);
			this._canvas.lock();
			
			var a:Number;
			var x:int;
			var y:int;
			
			// seconds
			ColorLog.setColor(SGR.BG_BRIGHT_YELLOW);
			a = (this._clock.secondsDegree - 90) * Math.PI / 180;
			x = Math.round(Math.cos(a) * 40);
			y = Math.round(Math.sin(a) * 20);
			this.drawLine(50, 25, 50 + x, 25 + y);
			
			// minutes
			ColorLog.setColor(SGR.BG_BRIGHT_MAGENTA);
			a = (this._clock.minutesDegree - 90) * Math.PI / 180;
			x = Math.round(Math.cos(a) * 30);
			y = Math.round(Math.sin(a) * 15);
			this.drawLine(50, 25, 50 + x, 25 + y);
			
			// hours
			ColorLog.setColor(SGR.BG_BRIGHT_CYAN);
			a = (this._clock.hoursDegree - 90) * Math.PI / 180;
			x = Math.round(Math.cos(a) * 20);
			y = Math.round(Math.sin(a) * 10);
			this.drawLine(50, 25, 50 + x, 25 + y);
			
			this._canvas.unlock();
			ColorLog.flush();
		}
		
		private function drawLine(x0:int, y0:int, x1:int, y1:int):void {
			var steep:Boolean = Math.abs(y1 - y0) > Math.abs(x1 - x0);
			var tmp:int;
			if (steep) {
				tmp = x0;
				x0 = y0;
				y0 = tmp;
				tmp = x1;
				x1 = y1;
				y1 = tmp;
			}
			if (x0 > x1) {
				tmp = x0;
				x0 = x1;
				x1 = tmp;
				tmp = y0;
				y0 = y1;
				y1 = tmp;
			}
			var deltax:int = x1 - x0;
			var deltay:int = Math.abs(y1 - y0);
			var error:int = deltax / 2;
			var ystep:int;
			var y:int = y0;
			if (y0 < y1) {
				ystep = 1;
			} else {
				ystep = -1;
			}
			for (var x:int = x0; x <= x1; x++) {
				if (steep) {
					this._canvas.setPixel(y, x, 0xffffff);
					ColorLog.moveTo(x, y);
					ColorLog.out(' ');
				} else {
					this._canvas.setPixel(x, y, 0xffffff);
					ColorLog.moveTo(y, x);
					ColorLog.out(' ');
				}
				error = error - deltay;
				if (error < 0) {
					y = y + ystep;
					error = error + deltax;
				}
			}
		}
	}
}